# coding: UTF-8

require 'style/formatter'

require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

M2W_WEBLOG_HATENA_DIARY_LINE_BREAK = "&amp;#10;"

#=はてなダイアリー専用のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_formatter.rb 495 2012-01-30 04:45:59Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryFormatter < Formatter

	def preset(original_content, content, contents, vars, errors, warnings)
	end

	def format(original_content, content, contents, vars, errors, warnings)
		M2W_LOGGER.debug("Start  #{self.class}#format ... original_content, contents = #{contents}, vars = #{vars}")

		# 全てのコンテンツに書式プラグインを適用する
		result = {'description' => ''}
		contents.each do |name, each_content|
			formatted_content = HikiDoc.to_xhtml(each_content, M2W_HIKI_OPTIONS).encode(M2W_SYSTEM_INNER_ENCODING, M2W_SYSTEM_HIKIDOC_ENCODING)
			result[name] = each_content.encode(M2W_SYSTEM_INNER_ENCODING)
		end

		description = __get_commentout_content(original_content)
		description << __get_commentout_attachment_urls_content({})
		description << result['description']
		result['description'] = description

		M2W_LOGGER.debug("Finish #{self.class}#format ... result = #{result}")

		return result
	end

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_HATENA_DIARY_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_HATENA_DIARY_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
