# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_GOO_LINE_BREAK = "&lb;"

#=Goo uÔ߂̐ptH[}b^[
#
# ŏ̒:: gDC[
# |Wg:: $Id: goo_formatter.rb 615 2012-03-16 23:57:45Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
# CZX:: CPL(Common Public Licence)
class GooFormatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_GOO_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_GOO_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
