# coding: UTF-8

require 'mailutils/mime'
require 'net/http'
require 'lib/exception/m2w_error'
require 'lib/exception/m2w_warning'

module WeblogPostCommon

	def post_medias(client, username, password, blogid, media_posters, errors, warnings)
		M2W_LOGGER.debug("Start  #{self.class}#post_medias")

		mime = Mime.new

		media_posters.each do |media_poster|
			media_url = nil
			begin
				media_url = post_media(media_poster.content, media_poster.media_name, client, blogid, errors, warnings)
				M2W_LOGGER.debug("post media ... media_url ... #{media_url}")
				if media_url == nil then
					errors.push(WeblogPluginError.new(
						"ファイル転送エラー(転送ファイル名 = #{media_poster.media_name})",
						"ファイル転送に失敗しました(転送ファイル名 = #{media_poster.media_name})。"))
				end
			rescue => e
				M2W_LOGGER.error("ファイルの転送に失敗しました。")
				M2W_LOGGER.error(e)
				errors.push(WeblogPluginError.new(
						"ファイル転送エラー(転送ファイル名 = #{media_poster.media_name})",
						"ファイル転送に失敗しました(転送ファイル名 = #{media_poster.media_name})。"))
			end

			# サムネイル画像を投稿する
			thumbnail_url = nil
			if M2W_SYSTEM_RMAGICK_SUPPORTED && media_url != nil && %r!^image/! =~ mime.mime(media_poster.media_name) then
				begin
					thumbnail = __create_thumbnail(media_poster.content, media_poster.thumbnail_setting)
				rescue => e
					M2W_LOGGER.error("サムネイルの作成に失敗しました。")
					M2W_LOGGER.error(e)
					errors.push(WeblogPluginError.new(
						"サムネイル作成エラー(ファイル名 = #{media_poster.thumbnail_name})",
						"サムネイルの作成に失敗しました(ファイル名 = #{media_poster.thumbnail_name})。"))
				end

				if thumbnail != nil then
					M2W_LOGGER.debug("create thumbnail ... thumbnail_name = #{media_poster.thumbnail_name}")

					begin
						thumbnail_url = post_media(thumbnail.to_blob, media_poster.thumbnail_name, client, blogid, errors, warnings)
						M2W_LOGGER.debug("post thumbnail ... thumbnail_url ... #{thumbnail_url}")
						if thumbnail_url == nil then
							errors.push(WeblogPluginError.new(
								"サムネイル転送エラー(ファイル名 = #{media_poster.thumbnail_name})",
								"サムネイルの転送に失敗しました(ファイル名 = #{media_poster.thumbnail_name})。"))
						end
					rescue => e
						M2W_LOGGER.error("ファイルの転送に失敗しました。")
						M2W_LOGGER.error(e)
						errors.push(WeblogPluginError.new(
							"サムネイル転送エラー(ファイル名 = #{media_poster.thumbnail_name})",
							"サムネイルの転送に失敗しました(ファイル名 = #{media_poster.thumbnail_name})。"))
					end
				end
			end

			media_poster.finish(media_url, thumbnail_url)
		end

		M2W_LOGGER.debug("Finish #{self.class}#post_medias")
	end

	def post_media(content, media_name, client, blogid, errors, warnings)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def get_header_for_post(header)
		result = header.clone
		result.delete_if do |key, value|
			key == M2W_FORMAT_PLUGIN_CONF_HEADER_NAME || key =~ /^fmt_[0-9a-zA-Z]+$/
		end

		return result
	end

	def request_trackback(client, header, blogid)
		M2W_LOGGER.debug("Start  #{self.class}#request_trackback ... header = #{header.to_s}, blogid = #{blogid}")

		if header['tb'] != nil then
			begin
				tb_urls = header['tb'].split(/[\s,]/)

				url = get_url4trackback(client, @report[:postid])
				blog_name = @parent.get_blog_name(client, blogid)

				title = header['title'] != nil ? header['title'] : ""
				excerpt = header['excerpt']
				if excerpt == nil then
					excerpt = ''
					# Ruby 1.9.0 より下のバージョンではマルチバイト文字列を綺麗に切れないため本文の要約に対応しない
					if RUBY_VERSION >= '1.9.0' then
						(header, content, contents) = @parent.mail_parser.parse_content(@report[:original_content])
						excerpt = contents['description'].length > 23 ? "#{contents['description'].slice(0, 23)} ..." : contents['description']
					end
				end

				tb_urls.each do |tb_url|
					M2W_LOGGER.debug("trackback to #{tb_url} ... title = #{title}, excerpt = #{excerpt}, url = #{url}, blog_name = #{blog_name}")
					response = Net::HTTP.post_form(
						URI.parse(tb_url),
						{
							'charset' => M2W_SYSTEM_INNER_ENCODING,
							'title' => title,
							'excerpt' => excerpt,
							'url' => url,
							'blog_name' => blog_name
						}
					)
					case response
					when Net::HTTPSuccess
						M2W_LOGGER.debug("trackback response = #{response.body}")
						if %r!<error>\s*([0-9]+)?\s*</error>! =~ response.body then
							error = $1
							if error != '0' then
								message = ''
								if %r!<message>(.+?)</message>! =~ response.body then
									message = $1
								end
								warnings.push(WeblogPluginWarning.new(
									"トラックバック送信エラー(送信先 = #{tb_url}, メッセージ = #{message})",
									"トラックバックの送信に失敗しました(送信先 = #{tb_url}, メッセージ = #{message})。"))
							end
						end
					else
						warnings.push(WeblogPluginWarning.new(
							"トラックバック送信エラー(送信先 = #{tb_url})",
							"トラックバックの送信に失敗しました(送信先 = #{tb_url}"))
					end
				end
			rescue => e
				M2W_LOGGER.error("トラックバックの転送に失敗しました。")
				M2W_LOGGER.error(e)
				warnings.push(WeblogPluginWarning.new(
					"トラックバック転送エラー(メッセージ = #{e.message})",
					"トラックバックの転送に失敗しました(メッセージ = #{e.message})。"))
			end

			M2W_LOGGER.debug("Finish #{self.class}#request_trackback")
		end
	end

	def get_url4trackback(client, postid)
		get_plugin = @parent.get_get_plugin()
		result = get_plugin.get(Mail2WeblogRequest.new(nil, {'postid' => postid}, ''))
		if get_plugin.report[:link] != nil then
			return get_plugin.report[:link]
		else
			raise WeblogPluginWarning.new(
				"リンク取得エラー",
				"リンクの取得に失敗しました。"
			)
		end
	end

	def get_blog_name(client, blogid)
	end

	def __create_thumbnail(content, thumbnail_setting)
		M2W_LOGGER.debug("Start  #{self.class}#__create_thumbnail ... thumbnail_setting = #{thumbnail_setting.to_s}")

		begin
			if thumbnail_setting != nil then
				if thumbnail_setting['scale'] != nil then
					M2W_LOGGER.debug("create thumbnail ... scale = #{thumbnail_setting['scale']}")
					return Magick::Image.from_blob(content).shift.scale(0.01 * thumbnail_setting['scale'].to_i)
				elsif thumbnail_setting['width'] != nil && thumbnail_setting['height'] != nil then
					M2W_LOGGER.debug("create thumbnail ... width = #{thumbnail_setting['width']}, height = #{thumbnail_setting['height']}")
					return Magick::Image.from_blob(content).shift.scale(thumbnail_setting['width'].to_i, thumbnail_setting['height'].to_i)
				end
			end

			M2W_LOGGER.debug("no create thumbnail ... setting = #{thumbnail_setting.to_s}")
			return nil
		ensure
			M2W_LOGGER.debug("Finish #{self.class}#__create_thumbnail")
		end
	end

end
