# coding: UTF-8

require 'net/smtp'
require 'mailutils/mail_processor'

#=メール通知
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_sender.rb 694 2012-05-19 00:32:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

class Mail2WeblogMailSender

	def initialize(
			smtp_server_address, smtp_server_port,
			smtp_security_type, smtp_server_user,
			smtp_server_password,
			smtp_pop3before_smtp_server_address,
			smtp_pop3before_smtp_server_port,
			smtp_pop3before_smtp_server_user,
			smtp_pop3before_smtp_server_password,
			subject_header,
			subject_separator,
			from_address,
			reply = M2W_REPLY,
			resendmail_count = M2W_RESENDMAIL_COUNT,
			wait_time_resending = 15)
		@smtp_server_address = smtp_server_address
		@smtp_server_port = smtp_server_port
		@smtp_security_type = smtp_security_type
		@smtp_server_user = smtp_server_user
		@smtp_server_password = smtp_server_password
		@smtp_pop3before_smtp_server_address = smtp_pop3before_smtp_server_address
		@smtp_pop3before_smtp_server_port = smtp_pop3before_smtp_server_port
		@smtp_pop3before_smtp_server_user = smtp_pop3before_smtp_server_user
		@smtp_pop3before_smtp_server_password = smtp_pop3before_smtp_server_password

		@subject_header = subject_header
		@subject_separator = subject_separator
		@from_address = from_address

		@reply = reply
		@resendmail_count = resendmail_count
		@wait_time_resending = wait_time_resending
	end

	def sendmail(mail)
		M2W_LOGGER.debug("Start  #{self.class.name}#sendmail")

		result = false
		if @reply then
			if !mail.instance_of?(Mail) && mail.respond_to?("to_s") then
				mail = MailProcessor.parse(mail.to_s)
			end

			M2W_LOGGER.debug("send mail ... subject = #{mail.subject}, from = #{MailProcessor.make_address_content(mail.from_address, M2W_SYSTEM_INNER_ENCODING)}, to = #{MailProcessor.make_addresses_content(mail.to_addresses, M2W_SYSTEM_INNER_ENCODING)}")

			error_count = 0
			while error_count <= @resendmail_count
				begin
					if @smtp_security_type == 'POPbeforeSMTP' then
						pop = Net::POP3.new(@smtp_pop3before_smtp_server_address, @smtp_pop3before_smtp_server_port)
						pop.start(@smtp_pop3before_smtp_server_user, @smtp_pop3before_smtp_server_password)
						pop.finish
					end

					if @smtp_security_type == 'SMTP-AUTH' then
						Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address, @smtp_server_user, @smtp_server_password, :login) do |smtp|
							smtp.send_message(
								MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
							)
						end
						result = true
						break
					else
						Net::SMTP.start(@smtp_server_address, @smtp_server_port, @smtp_server_address) do |smtp|
							smtp.send_message(
								MailProcessor.make(mail), mail.from_address.address, MailProcessor.make_address_list(mail.to_addresses)
							)
						end
						result = true
						break
					end
				rescue Net::SMTPError, EOFError => e
					M2W_LOGGER.error(e)
					error_count = error_count + 1
					sleep(@wait_time_resending) if @wait_time_resending > 0
				end
			end
		else
			M2W_LOGGER.debug("no send mail")
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#sendmail ... result = #{result}, error_count = #{error_count}")
		return result
	end

	def sendmail_as_command(command, param, header, content, to_address, attachments = [], mode = 'wiki', related_attachments = [])
		M2W_LOGGER.debug("Start  #{self.class.name}#sendmail_as_command")

		begin
			result = nil
			case mode
			when 'wiki'
				result = sendmail(Mail.new(make_title(command, param), @from_address, [to_address], make_content(header, content, mode), attachments))
			when 'html'
				result = sendmail(Mail.new(make_title(command, param), @from_address, [to_address], nil, attachments, make_content(header, content, mode), related_attachments))
			else
				raise FormatPluginError.new(
					"不明な書式モードエラー(フォーマットモード = #{mode})",
					"不明な書式モードを指定しました（フォーマットモード = #{mode}）。")
			end

			M2W_LOGGER.debug("Start  #{self.class.name}#sendmail_as_command ... result = #{result}")
			return result
		end
	end

	def make_title(command, param = nil)
		result = ""
		if @subject_header != nil then
			result << @subject_header
			result << @subject_separator
		end
		result << command
		if param != nil && param != "" then
			result << @subject_separator
			result << param.to_s
		end
		return result
	end

	def make_content(header, content, mode = 'wiki')
		M2W_LOGGER.debug("Start  #{self.class.name}#make_content ... header = #{header.to_s}, content = #{content}, mode = #{mode}")

		result = ""
		if header != nil && header.size > 0 then
			if header.instance_of?(Hash) then
				header.each do |key, value|
					case mode
					when 'wiki'
						result << "#{key}#{@subject_separator}#{value}\n"
					when 'html'
						result << "<div>#{key}#{@subject_separator}#{value}</div>\n"
					end
				end
			elsif header.kind_of?(Array) then
				index = 0
				while index < header.size
					case mode
					when 'wiki'
						result << "#{header[index]}#{@subject_separator}#{header[index + 1]}\n"
					when 'html'
						result << "<div>#{header[index]}#{@subject_separator}#{header[index + 1]}</div>\n"
					end
					index = index + 2
				end
			end

			case mode
			when 'wiki'
				result << "\n"
			when 'html'
				result << "<br />\n"
			end
		end
		if content != nil then
			result << content
		end

		M2W_LOGGER.debug("Finish #{self.class.name}#make_content ... result = #{result}")
		return result
	end

end
