# coding: UTF-8

require 'plugin/weblog/lib/standard_get'

#=metaWeblog API を使った標準のブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: meta_weblog_get.rb 780 2012-07-14 06:55:47Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogGet_WeblogPlugin < StandardGet_WeblogPlugin

	def get_article(client, postid)
		M2W_LOGGER.debug("Start  metaWeblog.getPost ... postid = #{postid}")
		@post = client.call("metaWeblog.getPost", postid, @parent.username, @parent.password)
		M2W_LOGGER.debug("Finish metaWeblog.getPost ... result = #{@post.to_s}")

		if @post['description'] == nil then
			raise WeblogPluginError.new(
				"本文取得エラー",
				"本文の取得に失敗しました。"
			)
		end

		if @post['link'] == nil then
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
		end

		return [@post['description'], @post['link']]
	end

end
