# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/t_diary/t_diary_delete'
require 'plugin/weblog/t_diary/t_diary_get'
require 'plugin/weblog/t_diary/t_diary_formatter'

M2W_WEBLOG_TDIARY_XMLRPC_ENCODING = 'UTF-8'

#=tDiary のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: t_diary.rb 779 2012-07-11 03:50:25Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TDiary_WeblogPlugin < MetaWeblog_WeblogPlugin

	def formatter
		return TDiaryFormatter.new(@plugin_manager)
	end

	def header_alias_for_post
		return {}
	end

	def client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING))
		return result
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_get_plugin()
		return TDiaryGet_WeblogPlugin.new(self)
	end

	# ブログ記事削除用のプラグインを取得します。
	def get_delete_plugin()
		return TDiaryDelete_WeblogPlugin.new(self)
	end

end
