# encoding: UTF-8

class Hash

	def deep_merge(target)
		result = {}

		result = self.clone

		if target.kind_of?(Hash)
			target.each do |key, value|
				if value.kind_of?(Hash) then
					if result[key] == nil then
						result[key] = {}
					end

					result[key] = result[key].deep_merge(value)
				else
					result[key] = value != nil ? value.clone : nil
				end
			end
		else
			raise ArgumentError('Not Hash')
		end

		return result
	end

	def deep_merge!(target)
		if target.kind_of?(Hash)
			target.each do |key, value|
				if value.kind_of?(Hash) then
					if self[key] == nil then
						self[key] = {}
					end

					self[key].deep_merge!(value)
				else
					self[key] = value != nil ? value.clone : nil
				end
			end
		else
			raise ArgumentError('Not Hash')
		end
	end

	if RUBY_VERSION < '1.9.0' then

		def to_s
			result = "{"
			keys.each_with_index do |key, index|
				result << ", " if 0 < index
				result << "#{key} => #{self[key]}"
			end
			result << "}"
			return result
		end

	end

end
