# coding: UTF-8

#=blogger API
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: blogger.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Blogger

	def initialize(client, username, password, to_encoding, from_encoding = nil)
		@client = client
		@username = username
		@password = password
		@to_encoding = to_encoding
		@from_encoding = from_encoding
	end

	def get_users_blogs(appkey = "")
		blogs = @client.call("blogger.getUsersBlogs", appkey, @username, @password)
		result = []
		blogs.each do |blog|
			result.push(Blog.new(__encode(blog["blogid"]), __encode(blog["url"]), __encode(blog["blogName"])))
		end
		return result
	end

	def __encode(buffer)
		if @to_encoding != nil then
			if @from_encoding != nil then
				return buffer.encode(@to_encoding, @from_encoding)
			else
				return buffer.encode(@to_encoding)
			end
		end

		return buffer
	end

end

class Blog

	attr_reader :blogid
	attr_reader :url
	attr_reader :blog_name

	def initialize(blogid, url, blog_name)
		@blogid = blogid
		@url = url
		@blog_name = blog_name
	end

	def to_s
		return "blogid = #{blogid}, url = #{url}, blog_name = #{blog_name}"
	end

end
