# coding: UTF-8

#=HTML 本文のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: formatter4htmlplain.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Formatter4HTMLPlain

	def Formatter4HTMLPlain.to_xhtml(content, vars)
		result = ""
		content = CGI.escapeHTML(content)

		# プラグインの印をつける
		state = 0
		buffers = content.split(/\n/)
		i = 0
		while i < buffers.size
			result << "<p>"
			line = buffers[i]
			block = true
			while true
				if line =~ /^(.*?)\{\{(.*)$/ then
					left = $1
					right = $2
					result << left
					block = block && (left.length == 0)
					if right =~ /^(.*?)\}\}(.*?)$/ then
						plugin_content = $1
						line = $2
						block = block && (line.length == 0)
						result << __plugin_content(plugin_content, block)
					else
						plugin_content = right
						plugin_content << "\n"
						(multiline_content, line_count, line) = __process_multiline_plugin(buffers, i)
						i = i + line_count
						plugin_content << multiline_content
						if line != nil then
							block = block && (line.length == 0)
							result << __plugin_content(plugin_content, block)
						else
							result << "{{"
							result << plugin_content.chomp
							result << "</p>\n"
							break
						end
					end
				else
					result << line
					result << "</p>\n"
					break
				end
			end

			i = i + 1
		end

		# 関連ファイルの URL を埋め込む
		urls = {}
		urls.merge!(vars[:related_attachment_urls]) if vars[:related_attachment_urls] != nil
		urls.merge!(vars[:related_thumbnail_urls]) if vars[:related_thumbnail_urls] != nil

		urls.each do |url_id, url|
			result = result.gsub("cid:#{url_id}", url)
		end

		return result
	end

	def Formatter4HTMLPlain.__process_multiline_plugin(buffers, i)
		line_count = 1
		plugin_content = ""

		while i + line_count < buffers.size
			if buffers[i + line_count] =~ /^(.*?)\}\}(.*?)$/ then
				left = $1
				right = $2
				plugin_content << left
				plugin_content << "\n"
				plugin_content.gsub!(/<[^>]+?>/, "")
				return [plugin_content.chomp, line_count, right]
			else
				plugin_content << buffers[i + line_count]
				plugin_content << "\n"
			end

			line_count = line_count + 1
		end

		plugin_content.gsub!(/<[^>]+?>/, "")
		return [plugin_content.chomp, line_count, nil]
	end

	def Formatter4HTMLPlain.__plugin_content(plugin_content, block)
		if block then
			return %Q!<div class="plugin">{{#{plugin_content}}}</div>!
		else
			return %Q!<span class="plugin">{{#{plugin_content}}}</span>!
		end
	end

end
