# encoding: UTF-8

require 'xmlrpc/client'

#=XML-RPC 用のライター
#
# 文字エンコードのサポートを行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: xmlrpc_writer.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class XMLRPCWriter < XMLRPC::XMLWriter::Simple

	def initialize(encoding)
		@encoding = encoding
	end

	def pi(name, *params)
		if @encoding == nil && params.join(" ") !~ /encoding/ then
			return "<?#{name} " + params.join(" ") + " ?>"
		else
			return "<?#{name} " + params.join(" ") + %Q! encoding="#{@encoding}"?>!
		end
	end

end
