# coding: UTF-8

require 'plugin/command/adapter/mail/lib/standard_command_adapter4mail'
require 'm2w_mail_parser_html_text_type'
require 'm2w_mail_parser_plain_text_type'

#=ブログ記事簡易投稿コマンドアダプタープラグイン（メール用）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: simple_post.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class SimplePost_CommandAdapterPlugin4Mail < Standard_CommandAdapterPlugin4Mail

	attr_writer :mail_parser
	attr_writer :mail_sender

	def create_request(command, mail)
		subject_parsed_result = @mail_parser.parse_subject(mail.escaped_prefix_subject)
		param = subject_parsed_result ? subject_parsed_result[1] : nil

		header = content = contents = nil
		html_header = html_content = html_contents = nil

		simple_header = nil
		if mail.has_content then
			(header, content, contents) = @mail_parser.parse_content(mail.content, command.header_alias(), Mail2WeblogMailParserPlainTextType.new)
			param = header['blogid'] if header.has_key?('blogid')
		end

		if mail.has_html_content then
			(html_header, html_content, html_contents) = @mail_parser.parse_content(mail.html_content, command.header_alias(), Mail2WeblogMailParserHtmlTextType.new)
			param = html_header['blogid'] if html_header.has_key?('blogid')
		end

		real_header = header != nil ? header : html_header
		title = real_header.has_key?('tit') ? real_header['tit'] : mail.subject
		real_header.delete('title')
		simple_header = {'tit' => title}
		simple_header.merge!(real_header)
		normal_mail = __normalize_mail(mail, simple_header, content, html_content)
		simple_header['title'] = title

		request_format = format(simple_header, mail)
		return Mail2WeblogRequest.new(
			:source => mail.from_address.address,
			:format => request_format,
			:param => param,
			:original_content => __original_content(request_format, normal_mail),
			:header => simple_header,
			:content => __content(request_format, normal_mail.content, normal_mail.html_content),
			:contents => __contents(request_format, contents, html_contents),
			:attachments => mail.attachments,
			:related_attachments => mail.related_attachments)
	end

	def __normalize_mail(mail, header, content, html_content)
		simple_content = content != nil ? @mail_sender.make_content(header, content, 'wiki') : nil
		simple_html_content = html_content != nil ? @mail_sender.make_content(header, html_content, 'html') : nil
		return Mail.new(mail.subject, mail.from_address, nil, simple_content, nil, simple_html_content)
	end

	def create_response(command, request, response)
		return response.success ? create_success_response(command, request, response) : create_failure_response(command, request, response)
	end

	def create_success_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の投稿に成功しました。

投稿記事のタイトル: #{response[:title]}
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'get',
			:param => request.param,
			:header => {"postid" => response[:postid]},
			:content => content
		))
		return response
	end

	def create_failure_response(command, request, response)
content = <<"END_CONTENT"
ブログ記事の投稿に失敗しました。
#{make_exception_contents(response)}
END_CONTENT

		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'error',
			:param => request.param,
			:content => content
		))
		return response
	end

end
