# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事投稿コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: post.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Post_CommandPlugin < StandardCommand

	def post_plugin
		return @post_plugin if @post_plugin
		@post_plugin = @weblog.get_post_plugin
		@post_plugin.logger = @logger if @post_plugin
		return @post_plugin
	end

	def header_alias()
		result = {}

		result = result.merge(post_plugin.header_alias) if post_plugin

		return result
	end

	def run_after_parsing(request)
		if post_plugin != nil then
			return post_plugin.post(request)
		else
			return Mail2WeblogResponse.new
		end
	end

end
