# coding: UTF-8

require 'hikidoc/hikidoc'

require 'plugin/format/lib/format_plugin_utils'

#=HTML を直接出力する書式プラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: raw.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Raw_FormatPlugin
	include FormatPluginUtils

	OPTION_ALIAS = {
	}
	OPTION_DEFAULT_VALUE = {
	}

	def plugin_contents(param, vars)
		(params, option, content) = get_format_plugin_parameter(param, vars, 0, OPTION_ALIAS, OPTION_DEFAULT_VALUE)

		htmloutput = HikiDoc::HTMLOutput.new(" />")

		return "<div>#{htmloutput.unescape_html(content)}</div>"
	end

	def plugin_contents_inline(param, vars)
		(params, option, content) = get_format_plugin_parameter(param, vars, 0, OPTION_ALIAS, OPTION_DEFAULT_VALUE)

		htmloutput = HikiDoc::HTMLOutput.new(" />")

		return "<span>#{htmloutput.unescape_html(content)}</span>"
	end

end
