# coding: UTF-8

require 'tempfile'
require 'mailutils/mime'
require 'plugin/weblog/lib/weblog_post_common'

module AtomPubWeblogPostCommon
	include WeblogPostCommon

	def post_media(content, media_name, client, blogid, errors, warnings)
		mime = Mime.new

		tempfile = Tempfile.new("content")
		tempfile.binmode
		tempfile.write(content)
		tempfile.close

		@logger.debug("Start  AtomPub.create_media ... media_name = #{media_name}") if @logger && @logger.debug?
		create_media_result = client.create_media(@parent.media_collection_uri, tempfile.path, mime.mime(media_name))
		@logger.debug("Finish AtomPub.create_media ... result = #{create_media_result}") if @logger && @logger.debug?

		media_url = nil

		if create_media_result != nil then
			@logger.debug("Start  AtomPub.get_media") if @logger && @logger.debug?
			media_entry = client.get_entry(create_media_result)
			@logger.debug("Finish AtomPub.get_media ... result = #{media_entry}") if @logger && @logger.debug?

			if media_entry != nil then
				media_entry.elem.each_element("content") do |element|
					media_url = element.attributes['src']
				end
			end
		end

		@logger.debug("post content media_result ... media_url = #{media_url}") if @logger && @logger.debug?
		return media_url
	end

end
