# coding: UTF-8

require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/goo/goo_formatter'
require 'plugin/weblog/goo/goo_edit'
require 'plugin/weblog/goo/goo_post'

M2W_WEBLOG_GOO_ENDPOINT = 'http://blog.goo.ne.jp/xmlrpc.php'

M2W_WEBLOG_GOO_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_GOO_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_GOO_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_WEBLOG_GOO_XMLRPC_ENCODING = 'UTF-8'

# Goo ブログにはタイムゾーンは存在せず日本時間で固定されている
M2W_WEBLOG_GOO_TIMEZONE_OFFSET = 9 * 3600

#=Goo ブログのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: goo.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Goo_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_GOO_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			encoding = M2W_WEBLOG_GOO_DEFAULT_ENCODING,
			default_blogid = M2W_WEBLOG_DEFAULT_BLOGID,
			attachment_root_path = M2W_WEBLOG_GOO_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_GOO_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias_for_post
		return {
			'cat' => M2W_WEBLOG_MT_CATEGORIES,
			'cats' => M2W_WEBLOG_MT_CATEGORIES,
		}
	end

	def client
		result = super
		return result
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return date + M2W_WEBLOG_GOO_TIMEZONE_OFFSET
	end

	def formatter
		return GooFormatter.new(@plugin_manager)
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return GooPost_WeblogPlugin.new(self)
	end

	# ブログ記事編集用のプラグインを取得します。
	def get_edit_plugin()
		return GooEdit_WeblogPlugin.new(self)
	end

end
