# coding: UTF-8

require 'blogger/blogger'
require 'plugin/weblog/movable_type/movable_type_edit.rb'

#=FC2 ブログのためのブログ記事編集用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: goo_edit.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class GooEdit_WeblogPlugin < MovableTypeEdit_WeblogPlugin

	def header_alias
		result = super
		return result.merge(@parent.header_alias_for_post)
	end

	alias :__edit_article edit_article

	def edit_article(client, blogid, postid, header, dateCreated)
		error_count = 0
		while true
			begin
				return __edit_article(client, blogid, postid, header, dateCreated)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def after(client, request, response)
		super

		request_trackback(client, request.header, response[:blogid], response[:postid], response[:formatted_contents]['description'])
	end

end
