# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_GOO_LINE_BREAK = "&lb;"

#=Goo ブログのための専用フォーマッター
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: goo_formatter.rb 916 2012-12-22 12:51:52Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class GooFormatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_GOO_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_GOO_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

	alias :____format :__format

	def __format(format, content, vars)
		return ____format(format, content, vars).gsub(/\r|\n/, '')
	end

end
