# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_get'

#=livedoor Blog のためのブログ記事取得用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: livedoor_get.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class LivedoorGet_WeblogPlugin < AtomPubGet_WeblogPlugin

	def parse_description(entry)
		entry.elem.each_element("blogcms:source/blogcms:body") do |element|
			return element.text
		end
		raise WeblogPluginError.new(
			"本文取得エラー",
			"本文の取得に失敗しました。"
		)
	end

	def parse_link(entry)
		entry.elem.each_element_with_attribute("rel", "alternate") do |element|
			return element.attributes['href']
		end
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
	end

end
