# coding: UTF-8

require 'plugin/weblog/lib/standard_post'
require 'plugin/weblog/meta_weblog/lib/meta_weblog_post_common'

#=metaWeblog API を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: meta_weblog_post.rb 906 2012-12-21 09:53:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2012. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPost_WeblogPlugin < StandardPost_WeblogPlugin
	include MetaWeblogPostCommon

	def post_temp_article(client, blogid)
		@logger.debug("Start  metaWeblog.newPost ... blogid = #{blogid}") if @logger && @logger.debug?
		postid = client.call(
			"metaWeblog.newPost",
			blogid,
			@parent.username,
			@parent.password,
			{'title' => M2W_TEMP_POST_TITLE, 'description' => M2W_TEMP_POST_DESCRIPTION},
			0)
		postid = parse_postid(postid).to_s
		@logger.debug("Finish metaWeblog.newPost ... postid = #{postid}") if @logger && @logger.debug?
		return postid
	end

	def repost_formatted_article(client, blogid, postid, header, dateCreated)
		@logger.debug("Start  metaWeblog.editPost ... header = #{header.keys.to_s}") if @logger && @logger.debug?
		result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, get_header_for_post(header), 1)
		@logger.debug("Finish metaWeblog.editPost ... result = #{result}") if @logger && @logger.debug?
	end

	def delete_temp_article(client, blogid, postid)
		@logger.debug("Start  blogger.deletePost ... blogid = #{blogid}, postid = #{postid}") if @logger && @logger.debug?
		result = client.call(
			"blogger.deletePost",
			1,
			postid,
			@parent.username,
			@parent.password,
			1)
		@logger.debug("Finish blogger.deletePost ... result = #{result}") if @logger && @logger.debug?
	end

	def parse_postid(postid)
		return postid
	end

end
