# coding: UTF-8

require 'm2w_request'
require 'm2w_response'

#=コマンドの標準実装
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_command.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardCommand

	attr_writer :weblog
	attr_writer :plugin_manager
	attr_writer :logger

	# public
	def run(request)
		@logger.debug("Start  #{self.class.name}#run") if @logger && @logger.debug?
		@report = {}

		if @weblog != nil then
			setup_weblog
		end

		run_before_parsing()
		begin
			return run_after_parsing(request)
		ensure
			@logger.debug("Finish #{self.class.name}#run") if @logger && @logger.debug?
		end
	end

	# overridable
	def setup_weblog
		@weblog.plugin_manager = @plugin_manager if @weblog.respond_to?("plugin_manager=")
	end

	# overridable
	def header_alias()
		return {}
	end

	# overridable
	def run_before_parsing
	end

	# overridable
	def run_after_parsing(request)
		return Mail2WeblogResponse.new(true)
	end

	def make_exception_contents(errors, warnings)
		result = ""

		if errors.length > 0 then
			result << "\n= エラー =\n\n"
			errors.each do |error|
				result << "*#{error.message}\n"
			end
		end

		if warnings.length > 0 then
			result << "\n= 警告 =\n\n"
			warnings.each do |warning|
				result << "*#{warning.message}\n"
			end
		end

		return result
	end

end
