# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_delete'

require 'style/formatter'

require 'atomutil/atomutil'

#=AtomPub を使った標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: atom_pub.rb 942 2013-01-11 00:10:24Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class AtomPub_WeblogPlugin

	attr_accessor :plugin_manager

	attr_reader :endpoint
	attr_reader :entry_collection_uri
	attr_reader :media_collection_uri
	attr_reader :username
	attr_reader :password

	attr_writer :logger

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			entry_collection_uri = M2W_WEBLOG_ENTRY_COLLECTION_URI,
			media_collection_uri = M2W_WEBLOG_MEDIA_COLLECTION_URI,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD)
		@endpoint = endpoint
		@entry_collection_uri = entry_collection_uri
		@media_collection_uri = media_collection_uri
		@username = username
		@password = password
	end

	def client
		auth = Atompub::Auth::Wsse.new(:username => @username, :password => @password)
		result = Atompub::Client.new(:auth => auth)
		result.get_service(@endpoint)
		return result
	end

	def formatter
		return Formatter.new(@plugin_manager)
	end

	# 文字列を日付に直します。
	def parse_date(date_string, default_date, errors, warnings)
		begin
			if @plugin_manager != nil then
				return @plugin_manager.parse_weblog_date(date_string, default_date)
			elsif date_string != nil
				return Time.parse(date_string)
			end
		rescue ArgumentError => e
			@logger.error("ブログ投稿期日の指定が不正でうまく認識できませんでした(ブログ投稿期日指定 = #{date_string})。") if @logger
			@logger.error(e) if @logger
			warnings.push(WeblogPluginWarning.new(
				"ブログ投稿期日指定不正(ブログ投稿期日指定 = #{date_string})。",
				"ブログ投稿期日が解析できませんでした。指定は無視して投稿時日付と解釈します(ブログ投稿期日指定 = #{date_string})。"))
		end

		return default_date
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return "#{date.strftime('%Y%m%dT%H:%M:%S')}Z"
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('attachment_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, thumbnail_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(thumbnail_filename)}"
	end

	# サムネイルのパスを取得します。
	def get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('thumbnail_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	def blog_name(cl = nil)
		begin
			cl = client() if cl == nil
			service = cl.get_service(@endpoint)
			if service != nil then
				workspace = cl.get_service(@endpoint).workspace
				if workspace != nil then
					return workspace.title if workspace.title != nil
				end
			end
		rescue Atompub::RequestError => e
			raise WeblogPluginError.new(
				"ブログ名取得エラー（メッセージ = #{e.message}）",
				"ブログ名の取得に失敗しました（メッセージ = #{e.message}）。"
			)
		end

		raise WeblogPluginError.new(
			"ブログ名取得エラー",
			"ブログ名の取得に失敗しました。"
		)
	end

	def get_post_plugin()
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def get_get_plugin()
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def get_edit_plugin()
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def get_delete_plugin()
		return AtomPubDelete_WeblogPlugin.new(self)
	end

end
