# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_FC2_LINE_BREAK = "&lb;"

#=FC2 ブログのための専用フォーマッター
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2_formatter.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Fc2Formatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_FC2_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_FC2_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
