# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_edit'

#=はてなダイアリーのためのブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_edit.rb 941 2013-01-08 06:41:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryEdit_WeblogPlugin < AtomPubEdit_WeblogPlugin

	def post_medias(client, username, password, media_posters, errors, warnings)
		@logger.debug("Start  #{self.class.name}#post_medias") if @logger && @logger.debug?
		if media_posters != nil then
			media_posters.each do |media_poster|
				warnings.push(WeblogPluginError.new(
					"ファイル転送未対応(転送ファイル名 = #{media_poster.media_name})",
					"ファイルの転送に対応していません（転送ファイル名 = #{media_poster.media_name}）。"))
			end
		end
		@logger.debug("Finish #{self.class.name}#post_medias") if @logger && @logger.debug?
	end

	def after(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'])
	end

end
