# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'
require 'exception/m2w_unknown_weblog_error'

#=ブログ記事削除コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: delete.rb 969 2013-04-29 06:36:40Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Delete_CommandPlugin < StandardCommand

	def delete_plugin
		if @weblog then
			return @delete_plugin if @delete_plugin
			@delete_plugin = @weblog.get_delete_plugin
			@delete_plugin.logger = @logger if @delete_plugin
			return @delete_plugin
		else
			return nil
		end
	end

	def header_alias()
		result = {}

		result = result.merge(delete_plugin.header_alias) if delete_plugin

		return result
	end

	def run_impl(request)
		if delete_plugin then
			return delete_plugin.delete(request)
		else
			raise Mail2WeblogUnknownWeblogError.new
		end
	end

end
