# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'
require 'exception/m2w_unknown_weblog_error'

#=ブログ記事編集コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: edit.rb 969 2013-04-29 06:36:40Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Edit_CommandPlugin < StandardCommand

	def edit_plugin
		if @weblog then
			return @edit_plugin if @edit_plugin
			@edit_plugin = @weblog.get_edit_plugin
			@edit_plugin.logger = @logger if @edit_plugin
			return @edit_plugin
		else
			return nil
		end
	end

	def header_alias()
		result = {}

		result = result.merge(edit_plugin.header_alias) if edit_plugin

		return result
	end

	def run_impl(request)
		if edit_plugin then
			return edit_plugin.edit(request)
		else
			raise Mail2WeblogUnknownWeblogError.new
		end
	end

end
