# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'
require 'exception/m2w_unknown_weblog_error'

#=ブログ記事取得コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 969 2013-04-29 06:36:40Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandPlugin < StandardCommand

	def get_plugin
		if @weblog then
			return @get_plugin if @get_plugin
			@get_plugin = @weblog.get_get_plugin
			@get_plugin.logger = @logger if @get_plugin
			return @get_plugin
		else
			return nil
		end
	end

	def header_alias()
		result = {}

		result = result.merge(get_plugin.header_alias) if get_plugin

		return result
	end

	def run_impl(request)
		if get_plugin then
			return get_plugin.get(request)
		else
			raise Mail2WeblogUnknownWeblogError.new
		end
	end
end
