# coding: UTF-8

require 'm2w_request'
require 'm2w_response'

#=コマンドの標準実装
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_command.rb 962 2013-04-09 07:52:53Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class StandardCommand

	attr_writer :weblog
	attr_writer :plugin_manager
	attr_writer :logger

	# public
	def run(request)
		@logger.debug("Start  #{self.class.name}#run") if @logger && @logger.debug?

		setup_weblog if @weblog
		response = run_impl(request)

		@logger.debug("Finish #{self.class.name}#run") if @logger && @logger.debug?

		return response
	end

	# overridable
	def header_alias()
		return {}
	end

	# overridable
	def setup_weblog
		@weblog.plugin_manager = @plugin_manager if @weblog.respond_to?("plugin_manager=")
		@weblog.logger = @logger if @weblog.respond_to?("logger=")
	end

	# overridable
	def run_impl(request)
		return Mail2WeblogResponse.new(true)
	end

end
