# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'
require 'exception/m2w_unknown_weblog_error'

#=ブログ記事投稿コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: post.rb 969 2013-04-29 06:36:40Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Post_CommandPlugin < StandardCommand

	def post_plugin
		if @weblog then
			return @post_plugin if @post_plugin
			@post_plugin = @weblog.get_post_plugin
			@post_plugin.logger = @logger if @post_plugin
			return @post_plugin
		else
			return nil
		end
	end

	def header_alias()
		result = {}

		result = result.merge(post_plugin.header_alias) if post_plugin

		return result
	end

	def run_impl(request)
		if post_plugin then
			return post_plugin.post(request)
		else
			raise Mail2WeblogUnknownWeblogError.new
		end
	end

end
