# coding: UTF-8

def File::basename(filename, suffix = "")
	suffix = suffix.gsub('.', '\.').gsub('*', '[^\.]+')

	pre_encoding = nil
	if filename.encoding.to_s.upcase != 'UTF-8' then
		pre_encoding = filename.encoding
		filename = filename.encode('UTF-8')
	end

	if %r!^(.*/)?(.+?)(#{suffix})?$! =~ filename then
		result = $2
		if pre_encoding != nil then
			return result.encode(pre_encoding, 'UTF-8')
		else
			return result
		end
	else
		return ""
	end
end

def File::extname(filename)
	pre_encoding = nil
	if filename.encoding.to_s.upcase != 'UTF-8' then
		pre_encoding = filename.encoding
		filename = filename.encode('UTF-8')
	end

	if /^.+(\.[^\.]+)$/ =~ filename then
		result = $1
		if pre_encoding != nil then
			return result.encode(pre_encoding, 'UTF-8')
		else
			return result
		end
	else
		return ""
	end
end
