# coding: UTF-8

#=メール解析
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_parser_plain_text_type.rb 946 2013-01-21 09:48:06Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogMailParserPlainTextType

	attr_writer :logger

	def initialize(logger = nil)
		@logger = logger
	end

	def split(content)
		return content.split(/\r\n|\r|\n/)
	end

	def is_space_line(line)
		return line == ''
	end

	def parse_header(line, subject_separator)
		if /^([0-9a-zA-Z_]+?)#{subject_separator}(.*)$/ =~ line then
			return [true, $1, $2]
		else
			return [false, nil, nil]
		end
	end

	def parse_format_plugin_header(key)
		if /^#{M2W_FORMAT_PLUGIN_CONF_HEADER_PREFIX}([0-9a-zA-Z_]+)$/ =~ key then
			return [true, $1]
		else
			return [false, nil]
		end
	end

	def parse_subject_separation(line, subject_separator)
		if line =~ /^([0-9a-zA-Z_]+?)(#{subject_separator})\2{3}$/
			return [true, $1]
		else
			return [false, nil]
		end
	end

	def arrange_content(content)
		return content.chomp
	end

end
