# coding: UTF-8

require 'erb'

#=ev[g
#
# ŏ̒:: gDC[
# |Wg:: $Id: m2w_template_manager.rb 966 2013-04-12 01:49:43Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# CZX:: CPL(Common Public Licence)
class Mail2WeblogTemplateManager

	attr_accessor :template_dir
	attr_accessor :encoding
	attr_writer :logger

	def initialize(template_dir = "#{M2W_ROOT_PATH}/mail_template", encoding = 'UTF-8', logger = nil)
		@template_dir = template_dir
		@encoding = encoding
		@logger = logger
	end

	def result(template_name, vars = {})
		@logger.debug("Start  #{self.class.name}#result ... template_name = #{template_name}, vars = #{vars.keys.to_s}") if @logger && @logger.debug?

		template = open("#{template_dir}/#{template_name}.erb", "rb") { |file| file.read }
		template.force_encoding(@encoding) if @encoding
		result = ERB.new(template, nil, "-").result(Kernel::binding)

		@logger.debug("Finish #{self.class.name}#result") if @logger && @logger.debug?
		return result
	end

end
