# coding: UTF-8

#=Ȉ CSV vZbT[
#
# ŏ̒:: gDC[
# |Wg:: $Id: simple_csv.rb 984 2013-06-28 23:44:08Z toy_dev $
# 쌠:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# CZX:: CPL(Common Public Licence)
class SimpleCSVProcessor

	def initialize(param_separator, quote_char)
		@param_separator = param_separator
		@quote_char = quote_char
	end

	def parse(line)
		result = []
	
		state = 1
		i = 0
		buffer = ""
		while i < line.length
			str = line[i]
	
			case state
			when 1  # head
				case str
				when @quote_char[0]
					state = 3  # quoting
				when @param_separator[0]
					result.push(buffer)
					buffer = ""
					# next data
				else
					buffer << str
					state = 2  # no_quote
				end
			when 2  # no_quote
				case str
				when @param_separator[0]
					result.push(buffer)
					buffer = ""
					state = 1  # head
					# next data
				else
					buffer << str
				end
			when 3  # quoting
				case str
				when @quote_char[0]
					state = 4  # quote_end
				else
					buffer << str
				end
			when 4
				case str
				when @quote_char[0]
					buffer << str
					state = 3
				when @param_separator[0]
					result.push(buffer)
					buffer = ""
					state = 1	# head
					# next data
				else
					raise ArgumentError.new(line)
				end
			end
	
			i = i + 1
		end
	
		if state == 3 then
			raise ArgumentError.new(line)
		else
			result.push(buffer)
		end
	
		return result
	end

	def __get_option(params, vars)
		option_separator = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME)

		result = {}
		params.each do |param|
			(key, value) = param.split(option_separator, 2)
			result[key] = value
		end

		return result
	end

	def __merge_option(result, target, option_alias, vars)
		option_delete_mark = format_plugin_common_conf(vars, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_DELETE_MARK_NAME)

		if target != nil then
			target.each do |key, value|
				if /(#{option_delete_mark})?(.+)$/ =~ key then
					option_delete_flug = $1
					option_key = $2
					real_key = option_alias.has_key?(option_key) ? option_alias[option_key] : option_key
					if option_delete_flug != option_delete_mark then
						result[real_key] = value
					else
						result.delete(real_key)
					end
				end
			end
		end
	end

	def format_plugin_common_conf(vars, key)
		conf = vars[M2W_FORMAT_PLUGIN_COMMON_CONF_NAME]

		result = nil
		if conf != nil then
			result = conf[key]
		end

		if result != nil then
			return result
		else
			return M2W_FORMAT_PLUGIN_CONF_DEFAULT_VALUE[key]
		end
	end

	def set_format_plugin_common_conf(vars, value)
		if value != nil then
			vars[M2W_FORMAT_PLUGIN_COMMON_CONF_NAME] = value
		end
	end

	def set_format_plugin_conf(vars, value)
		if value != nil then
			vars[M2W_FORMAT_PLUGIN_CONF_NAME] = value
		end
	end

end
