# coding: UTF-8

require 'plugin/command/adapter/mail/lib/standard_command_adapter4mail'

#=ブログ記事編集コマンドアダプタープラグイン（メール用）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: edit.rb 995 2013-06-30 17:38:23Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Edit_CommandAdapterPlugin4Mail < Standard_CommandAdapterPlugin4Mail

	def create_response(command, request, response)
		return response.success ? create_success_response(command, request, response) : create_failure_response(command, request, response)
	end

	def create_success_response(command, request, response)
		send_content = @template_manager.result("reply/post", {
			:article_title => response[:title],
			:article_link => response[:link],
			:exception_contents => make_exception_contents(response),
		})
		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'get',
			:param => request.param,
			:header => {"postid" => response[:postid]},
			:content => send_content
		))
		return response
	end

	def create_failure_response(command, request, response)
		send_content = @template_manager.result("reply/failure", {
			:action => "編集",
			:exception_contents => make_exception_contents(response),
		})
		response.notices.push(Mail2WeblogResponseNotice.new(
			:destination => request.source,
			:type => 'error',
			:param => request.param,
			:content => send_content
		))
		return response
	end

end
