# coding: UTF-8

require 'plugin/command/lib/standard_command'
require 'exception/m2w_unknown_weblog_error'

#=ブログ記事取得コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandPlugin < StandardCommand

	def header_alias()
		result = {}

		result = result.merge(@weblog.header_alias) if @weblog

		return result
	end

	def run_impl(request)
		if @weblog then
			return @weblog.get(request)
		else
			raise Mail2WeblogUnknownWeblogError.new
		end
	end
end
