# coding: UTF-8

require 'plugin/weblog/lib/standard'
require 'plugin/weblog/atom_pub/lib/atom_pub_weblog_post_common'

require 'style/formatter'

require 'atomutil/atomutil'

#=AtomPub を使った標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: atom_pub.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class AtomPub_WeblogPlugin < Standard_WeblogPlugin
	include AtomPubWeblogPostCommon

	attr_accessor :plugin_manager

	attr_reader :endpoint
	attr_reader :entry_collection_uri
	attr_reader :media_collection_uri
	attr_reader :username
	attr_reader :password

	attr_writer :logger

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			entry_collection_uri = M2W_WEBLOG_ENTRY_COLLECTION_URI,
			media_collection_uri = M2W_WEBLOG_MEDIA_COLLECTION_URI,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD)
		@endpoint = endpoint
		@entry_collection_uri = entry_collection_uri
		@media_collection_uri = media_collection_uri
		@username = username
		@password = password
	end

	def create_client
		auth = Atompub::Auth::Wsse.new(:username => @username, :password => @password)
		result = Atompub::Client.new(:auth => auth)
		result.get_service(@endpoint)
		return result
	end

	def create_formatter
		return Formatter.new(@plugin_manager)
	end

	# 文字列を日付に直します。
	def parse_date(date_string, default_date, errors, warnings)
		begin
			if @plugin_manager != nil then
				return @plugin_manager.parse_weblog_date(date_string, default_date)
			elsif date_string != nil
				return Time.parse(date_string)
			end
		rescue ArgumentError => e
			@logger.error("ブログ投稿期日の指定が不正でうまく認識できませんでした(ブログ投稿期日指定 = #{date_string})。") if @logger
			@logger.error(e) if @logger
			warnings.push(WeblogPluginWarning.new(
				"ブログ投稿期日指定不正(ブログ投稿期日指定 = #{date_string})。",
				"ブログ投稿期日が解析できませんでした。指定は無視して投稿時日付と解釈します(ブログ投稿期日指定 = #{date_string})。"))
		end

		return default_date
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return "#{date.strftime('%Y%m%dT%H:%M:%S')}Z"
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# 添付ファイルのパスを取得します。
	def get_attachment_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('attachment_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, thumbnail_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(thumbnail_filename)}"
	end

	# サムネイルのパスを取得します。
	def get_thumbnail_filepath(postid, dateCreated, attachment_index, attachment_filename)
		default = get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		if @plugin_manager != nil then
			return @plugin_manager.get_weblog_filepath('thumbnail_url', postid, dateCreated, attachment_index, attachment_filename, default)
		else
			return default
		end
	end

	def blog_name(client = nil)
		begin
			client = create_client() if client == nil
			service = client.get_service(@endpoint)
			if service != nil then
				workspace = client.get_service(@endpoint).workspace
				if workspace != nil then
					return workspace.title if workspace.title != nil
				end
			end
		rescue Atompub::RequestError => e
			@logger.error("ブログ情報の取得に失敗しました。") if @logger
			@logger.error(e) if @logger
			raise WeblogPluginError.new(
				"ブログ名取得エラー",
				"ブログ名の取得に失敗しました。"
			)
		end

		raise WeblogPluginError.new(
			"ブログ名取得エラー",
			"ブログ名の取得に失敗しました。"
		)
	end



	def get_article(client, postid)
		@logger.debug("Start  AtomPub.get_entry ... postid = #{postid}") if @logger && @logger.debug?
		entry = client.get_entry("#{@entry_collection_uri}/#{postid}")
		@logger.debug("Finish AtomPub.get_entry") if @logger && @logger.debug?

		return [entry, parse_description(entry), parse_link(entry), parse_title(entry)]
	end

	def parse_description(article)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def parse_link(article)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def parse_title(article)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end



	def post_temp_article(client)
		@logger.debug("Start  AtomPub.create_entry ... endpoist = #{@entry_collection_uri}") if @logger && @logger.debug?
		new_entry = Atom::Entry.new(
			:title => M2W_TEMP_POST_TITLE.encode("BINARY", "BINARY"),
			:content => M2W_TEMP_POST_DESCRIPTION.encode("BINARY", "BINARY"))
		entry_uri = client.create_entry(@entry_collection_uri, new_entry)
		postid = parse_postid(entry_uri)
		@logger.debug("Finish AtomPub.create_entry ... entry_uri = #{entry_uri}, postid = #{postid}") if @logger && @logger.debug?
		return postid
	end

	def repost_formatted_article(client, postid, header, dateCreated)
		@logger.debug("Start  AtomPub.update_entry ...") if @logger && @logger.debug?
		entry = {}
		entry[:title] = header['title'].encode('BINARY', 'BINARY') if header['title']
		entry[:content] = header['description'].encode('BINARY', 'BINARY') if header['description']
		new_entry = Atom::Entry.new(entry)
		result = client.update_entry("#{@entry_collection_uri}/#{postid}", new_entry)
		@logger.debug("Finish AtomPub.update_entry ... result = #{result}") if @logger && @logger.debug?
	end

	def delete_temp_article(client, postid)
		@logger.debug("Start  AtomPub.delete_entry ... postid = #{postid}") if @logger && @logger.debug?
		result = client.delete_entry("#{@entry_collection_uri}/#{postid}")
		@logger.debug("Finish AtomPub.delete_entry ... result = #{result}") if @logger && @logger.debug?
	end

	def parse_postid(entry_uri)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end



	def edit_article(client, postid, header, dateCreated)
		@logger.debug("Start  AtomPub.update_entry ... entry_uri = #{@entry_collection_uri}/#{postid}") if @logger && @logger.debug?
		entry = {}
		entry[:title] = header['title'].encode('BINARY', 'BINARY') if header['title']
		entry[:content] = header['description'].encode('BINARY', 'BINARY') if header['description']
		update_entry = Atom::Entry.new(entry)
		@logger.debug("entry = #{update_entry.to_s}") if @logger && @logger.debug?
		entry_uri = client.update_entry("#{@entry_collection_uri}/#{postid}", update_entry)
		@logger.debug("Finish AtomPub.update_entry ... entry_uri = #{entry_uri}") if @logger && @logger.debug?
	end



	def delete_article(client, postid)
		@logger.debug("Start  AtomPub.delete_entry ... postid = #{postid}") if @logger && @logger.debug?
		client.delete_entry("#{@entry_collection_uri}/#{postid}")
		@logger.debug("Finish AtomPub.delete_entry") if @logger && @logger.debug?

		return true
	end

end
