# coding: UTF-8

require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/fc2/fc2_formatter'

M2W_WEBLOG_FC2_ENDPOINT = 'http://blog.fc2.com/xmlrpc.php'

M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_FC2_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_WEBLOG_FC2_XMLRPC_ENCODING = 'UTF-8'

#=FC2 ブログのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Fc2_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_FC2_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			blogid = M2W_WEBLOG_BLOGID,
			attachment_root_path = M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_FC2_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias_for_post
		return {
			'cat' => M2W_WEBLOG_MT_CATEGORIES,
			'cats' => M2W_WEBLOG_MT_CATEGORIES,
		}
	end

	def create_client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_FC2_XMLRPC_ENCODING))
		return result
	end

	def create_formatter
		return Fc2Formatter.new(@plugin_manager)
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end



	def after_get(client, request, response)
		super

		if request.header['dat'] == nil && response[:article]['dateCreated'] != nil then
			response[:additional_header] = {} if response[:additional_header] == nil
			response[:additional_header].merge!('dat' => get_date(response[:article]['dateCreated'].to_time))
		end
	end



	def after_post(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end



	def after_edit(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end

end
