# coding: UTF-8

require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/goo/goo_formatter'

M2W_WEBLOG_GOO_ENDPOINT = 'http://blog.goo.ne.jp/xmlrpc.php'

M2W_WEBLOG_GOO_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_GOO_THUMBNAIL_ROOT_PATH = 'thumbs'

# Goo ブログにはタイムゾーンは存在せず日本時間で固定されている
M2W_WEBLOG_GOO_TIMEZONE_OFFSET = 9 * 3600

#=Goo ブログのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: goo.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Goo_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_GOO_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			blogid = M2W_WEBLOG_BLOGID,
			attachment_root_path = M2W_WEBLOG_GOO_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_GOO_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias
		result = super
		return result.merge({
			'cat' => M2W_WEBLOG_MT_CATEGORIES,
			'cats' => M2W_WEBLOG_MT_CATEGORIES,
		})
	end

	def create_client
		result = super
		return result
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return date + M2W_WEBLOG_GOO_TIMEZONE_OFFSET
	end

	def create_formatter
		return GooFormatter.new(@plugin_manager)
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end



	def parse_postid(postid)
		return postid.split[0]
	end

	alias :__post_temp_article post_temp_article
	alias :__repost_formatted_article repost_formatted_article
	alias :__delete_temp_article delete_temp_article

	def post_temp_article(client)
		error_count = 0
		while true
			begin
				return __post_temp_article(client)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def repost_formatted_article(client, postid, header, dateCreated)
		error_count = 0
		while true
			begin
				return __repost_formatted_article(client, postid, header, dateCreated)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def delete_temp_article(client, postid)
		error_count = 0
		while true
			begin
				return __delete_temp_article(client, postid)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def after_post(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end



	alias :__edit_article edit_article

	def edit_article(client, postid, header, dateCreated)
		error_count = 0
		while true
			begin
				return __edit_article(client, postid, header, dateCreated)
			rescue XMLRPC::FaultException => e
				@logger.error("XML-RPC の操作に失敗したのでリトライします。 ... #{error_count}") if @logger != nil && @logger.error?
				@logger.error(e) if @logger != nil && @logger.error?
				sleep 1
				error_count = error_count + 1
				raise e if 10 <= error_count
			end
		end
	end

	def after_edit(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end

end
