# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub'

#=はてなダイアリーのためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiary_WeblogPlugin < AtomPub_WeblogPlugin

	def create_formatter
		return HatenaDiaryFormatter.new(@plugin_manager)
	end



	def get_attachments(urls)
		return []
	end

	def parse_description(entry)
		entry.elem.each_element("hatena:syntax") do |element|
			return element.text
		end
		raise WeblogPluginError.new(
			"本文取得エラー",
			"本文の取得に失敗しました。"
		)
	end

	def parse_link(entry)
		entry.elem.each_element_with_attribute("rel", "alternate") do |element|
			return element.attributes['href']
		end
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
	end

	def parse_title(entry)
		entry.elem.each_element("title") do |element|
			return element.text
		end
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
	end



	def post_medias(client, username, password, media_posters, errors, warnings)
		@logger.debug("Start  #{self.class.name}#post_medias") if @logger && @logger.debug?
		if media_posters != nil then
			media_posters.each do |media_poster|
				warnings.push(WeblogPluginError.new(
					"ファイル転送未対応(転送ファイル名 = #{media_poster.media_name})",
					"ファイルの転送に対応していません（転送ファイル名 = #{media_poster.media_name}）。"))
			end
		end
		@logger.debug("Finish #{self.class.name}#post_medias") if @logger && @logger.debug?
	end

	def parse_postid(entry_uri)
		if %r!/(([0-9]+/)?[0-9]+)$! =~ entry_uri then
			return $1
		else
			return nil
		end
	end

	def after_post(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'])
	end



	def post_medias(client, username, password, media_posters, errors, warnings)
		@logger.debug("Start  #{self.class.name}#post_medias") if @logger && @logger.debug?
		if media_posters != nil then
			media_posters.each do |media_poster|
				warnings.push(WeblogPluginError.new(
					"ファイル転送未対応(転送ファイル名 = #{media_poster.media_name})",
					"ファイルの転送に対応していません（転送ファイル名 = #{media_poster.media_name}）。"))
			end
		end
		@logger.debug("Finish #{self.class.name}#post_medias") if @logger && @logger.debug?
	end

	def after_edit(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'])
	end

end
