# coding: UTF-8

require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

require 'open-uri'

#=標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_delete.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Standard_WeblogPlugin

	def delete(request)
		@logger.debug("Start  #{self.class.name}#delete ... header = #{request.header.to_s}") if @logger && @logger.debug?
		result = false

		client = create_client
		formatter = create_formatter
		postid = request.header['postid']
		response = Mail2WeblogResponse.new

		before_delete(client, request, response)

		begin
			(post, description, link, title) = get_article(client, postid)
			response[:title] = title
			response[:link] = link

			result = delete_article(client, postid)
		rescue => e
			@logger.error("ブログ記事の削除に失敗しました。") if @logger
			@logger.error(e) if @logger
			response.errors.push(WeblogPluginError.new(
				"ブログ記事削除エラー(メッセージ = #{e.message})",
				"ブログ記事の削除に失敗しました(メッセージ = #{e.message})。"))
			@logger.debug("Finish #{self.class.name}#delete ... result = false") if @logger && @logger.debug?
			return response
		end

		response[:postid] = postid.to_s

		after_delete(client, request, response)

		@logger.debug("Finish #{self.class.name}#delete ... result = #{result}") if @logger && @logger.debug?
		response.success = result
		return response
	end

	def before_delete(client, request, response)
	end

	def delete_article(client, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

	def after_delete(client, request, response)
	end

end
