# coding: UTF-8

require 'plugin/weblog/lib/weblog_plugin_error'
require 'plugin/weblog/lib/weblog_plugin_warning'

#=標準のウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: standard_get.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Standard_WeblogPlugin

	def get(request)
		@logger.debug("Start  #{self.class.name}#get ... header = #{request.header.to_s}") if @logger && @logger.debug?

		client = create_client
		formatter = create_formatter
		formatter.logger = @logger
		postid = request.header['postid']
		response = Mail2WeblogResponse.new

		if postid != nil then
			begin
				before_get(client, request, response)

				# ブログ記事を取得する
				description = nil
				begin
					(article, description, link) = get_article(client, postid)
					response[:article] = article
					response[:postid] = postid
					response[:link] = link
				rescue => e
					@logger.error("ブログ記事の取得に失敗しました。") if @logger
					@logger.error(e) if @logger
					response.errors.push(WeblogPluginError.new(
						"ブログ記事取得エラー(メッセージ = #{e.message})",
						"ブログ記事の取得に失敗しました(メッセージ = #{e.message})。"))
					@logger.debug("Finish #{self.class.name}#get ... result = false") if @logger && @logger.debug?
					return response
				end

				# ブログ記事情報を解析する
				(version, original_content, original_content_type) = formatter.get_uncommentout_content(description)
				if original_content != nil then
					response[:original_content] = nil
					case original_content_type
					when 'wiki', 'htmlplain'
						response[:mode] = 'wiki'
						response[:original_content] = original_content
					when 'html'
						response[:mode] = 'html'
						response[:original_content] = original_content
					else
						@logger.error("取得したブログ記事の形式に対応できませんでした。") if @logger
						response.errors.push(WeblogPluginError.new(
							"ブログ記事取得エラー(メッセージ = 未対応形式)",
							"ブログ記事の取得に失敗しました(メッセージ = 未対応形式)。"))
						@logger.debug("Finish #{self.class.name}#get ... result = false") if @logger && @logger.debug?
						return response
					end
					attachment_urls = formatter.get_uncommentout_attachment_urls_content(description)
					related_attachment_urls = formatter.get_uncommentout_related_attachment_urls_content(description)
					response[:attachments] = get_attachments(attachment_urls)
					response[:related_attachments] = get_related_attachments(related_attachment_urls)

					after_get(client, request, response)

					@logger.debug("Finish #{self.class.name}#get ... result = true") if @logger && @logger.debug?
					response.success = true
					return response
				else
					@logger.error("ブログ記事を取得できませんでした。") if @logger
					response.errors.push(WeblogPluginError.new(
						"ブログ記事取得エラー(メッセージ = 未対応形式)",
						"ブログ記事の取得に失敗しました(メッセージ = 未対応形式)。"))
					@logger.debug("Finish #{self.class.name}#get ... result = false") if @logger && @logger.debug?
					return response
				end
			rescue => e
				@logger.error("ブログ記事の取得に失敗しました。") if @logger
				@logger.error(e) if @logger
				response.errors.push(WeblogPluginError.new(
					"ブログ記事取得エラー(メッセージ = #{e.message})",
					"ブログ記事の取得に失敗しました(メッセージ = #{e.message})。"))
			end
		else
			@logger.error("投稿ＩＤの指定がありません。") if @logger
			response.errors.push(WeblogPluginError.new(
				"投稿ＩＤ指定不足",
				"投稿ＩＤの指定がありませんでした。"))
		end

		@logger.debug("Finish #{self.class.name}#get ... result = false") if @logger && @logger.debug?
		return response
	end

	def get_attachments(urls)
		@logger.debug("Start  #{self.class.name}#get_attachments ... urls = #{urls.to_s}") if @logger && @logger.debug?
		result = []

		urls.each do |index, url|
			begin
				if url != nil then
					open(url, 'rb') do |f|
						attachment_content = f.gets(nil)
						if %r!/([^/]+)$! =~ url then
							attachment_filename = $1
							@logger.debug("attachment ... index = #{index.to_i - 1}, filename = #{attachment_filename}") if @logger && @logger.debug?
							result[index.to_i - 1] = MailAttachment.new(attachment_filename, attachment_content)
						end
					end
				else
					@logger.debug("no attachment ... index = #{index.to_i - 1}") if @logger && @logger.debug?
					result[index.to_i - 1] = nil
				end
			rescue => e
				@logger.error("添付ファイルの取得に失敗しました。") if @logger
				@logger.error(e) if @logger
				response.errors.push(WeblogPluginError.new(
					"添付ファイル取得エラー(メッセージ = #{e.message})",
					"添付ファイルの取得に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		@logger.debug("Finish #{self.class.name}#get_attachments ... result = #{result.size}") if @logger && @logger.debug?
		return result
	end

	def get_related_attachments(urls)
		@logger.debug("Start  #{self.class.name}#get_related_attachments ... urls = #{urls.to_s}") if @logger && @logger.debug?
		result = []

		urls.each do |content_id, url|
			begin
				if url != nil then
					open(url, 'rb') do |f|
						attachment_content = f.gets(nil)
						if %r!/([^/]+)$! =~ url then
							attachment_filename = $1
							@logger.debug("attachment ... content_id = #{content_id}, filename = #{attachment_filename}") if @logger && @logger.debug?
							result.push(MailAttachment.new(attachment_filename, attachment_content, content_id))
						end
					end
				end
			rescue => e
				@logger.error("添付ファイルの取得に失敗しました。") if @logger
				@logger.error(e) if @logger
				response.errors.push(WeblogPluginError.new(
					"添付ファイル取得エラー(メッセージ = #{e.message})",
					"添付ファイルの取得に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		@logger.debug("Finish #{self.class.name}#get_related_attachments ... result = #{result.size}") if @logger && @logger.debug?
		return result
	end

	def before_get(client, request, response)
	end

	def after_get(client, request, response)
	end

	def get_article(client, postid)
		raise WeblogPluginError.new(
			"未実装エラー",
			"実装されていません。")
	end

end
