# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub'

M2W_WEBLOG_LIVEDOOR_ENDPOINT = 'http://livedoor.blogcms.jp/atom/'

#=livedoor Blog のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: livedoor.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Livedoor_WeblogPlugin < AtomPub_WeblogPlugin

	def parse_description(entry)
		entry.elem.each_element("blogcms:source/blogcms:body") do |element|
			return element.text
		end
		raise WeblogPluginError.new(
			"本文取得エラー",
			"本文の取得に失敗しました。"
		)
	end

	def parse_link(entry)
		entry.elem.each_element_with_attribute("rel", "alternate") do |element|
			return element.attributes['href']
		end
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
	end

	def parse_title(entry)
		entry.elem.each_element("title") do |element|
			return element.text
		end
		raise WeblogPluginError.new(
			"リンク取得エラー",
			"リンクの取得に失敗しました。"
		)
	end



	def parse_postid(entry_uri)
		if %r!/(([0-9]+/)?[0-9]+)$! =~ entry_uri then
			return $1
		else
			return nil
		end
	end

	def after_post(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end



	def after_edit(client, request, response)
		super

		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end

end
