# coding: UTF-8

require 'plugin/weblog/lib/weblog_post_common'

module MetaWeblogPostCommon
	include WeblogPostCommon

	def post_media(content, media_name, client, errors, warnings)
		media_url = nil

		@logger.debug("Start  metaWeblog.newMediaObject ... media_name = #{media_name}") if @logger && @logger.debug?
		media_result = client.call("metaWeblog.newMediaObject", @blogid, @username, @password,
			{"bits" => XMLRPC::Base64.new(content), "name" => media_name}
		)
		@logger.debug("Finish metaWeblog.newMediaObject ... result = #{media_result}") if @logger && @logger.debug?

		if media_result != nil && media_result.has_key?('url') then
			# 必要時、URL を適切な値に変換する
			# ※ 必要時とは、Movable Type におけるとても稀有な例である。
			# ※ 詳細については MovableType_WeblogPlugin#transform_media_url に記載する。
			media_url = respond_to?('transform_media_url') ? transform_media_url(media_result['url'], media_name) : media_result['url']
		end

		@logger.debug("post content media_result ... media_url = #{media_url}") if @logger && @logger.debug?
		return media_url
	end

end
