# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'

M2W_WEBLOG_MT_CATEGORIES = 'categories'
M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH = 'attachments/'
M2W_WEBLOG_MT_THUMBNAIL_ROOT_PATH = 'thumbnails/'

#=Movable Type のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableType_WeblogPlugin < MetaWeblog_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			blogid = M2W_WEBLOG_BLOGID,
			attachment_root_path = M2W_WEBLOG_MT_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_MT_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias
		result = super
		return result.merge({
			'keys' => 'mt_keywords',
			'tags' => 'mt_tags',
			'tb' => 'mt_tb_ping_urls',
			'cats' => M2W_WEBLOG_MT_CATEGORIES
		})
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}/#{attachment_index}#{File.extname(attachment_filename)}"
	end



	def before_post(client, request, response)
		super

		if request.header['mt_tb_ping_urls'] != nil then
			request.header['mt_tb_ping_urls'] = request.header['mt_tb_ping_urls'].split(/[\s,]/)
		end

		response[:categories] = request.header[M2W_WEBLOG_MT_CATEGORIES]
		request.header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after_post(client, request, response)
		super

		__set_post_categories(client, response[:postid], response[:categories], @plugin_manager.get_weblog_autocategories, response.errors, response.warnings)
		__publish_post(client, response[:postid], response.errors, response.warnings)
	end



	def before_edit(client, request, response)
		super

		if request.header['mt_tb_ping_urls'] != nil then
			request.header['mt_tb_ping_urls'] = request.header['mt_tb_ping_urls'].split(/[\s,]/)
		end

		response[:categories] = request.header[M2W_WEBLOG_MT_CATEGORIES]
		request.header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after_edit(client, request, response)
		super

		__set_post_categories(client, response[:postid], response[:categories], @plugin_manager.get_weblog_autocategories, response.errors, response.warnings)
		__publish_post(client, response[:postid], response.errors, response.warnings)
	end



	# ブログ記事にカテゴリを設定する
	def __set_post_categories(client, postid, categories, autocategory, errors, warnings)
		if categories || autocategory then
			begin
				@logger.debug("Start  mt.getCategoryList ... categories = #{categories}") if @logger && @logger.debug?
				category_map = __get_category_map(client.call("mt.getCategoryList", @blogid, @username, @password), errors, warnings)
				@logger.debug("Finish mt.getCategoryList ... category_map = #{category_map}") if @logger && @logger.debug?

				@logger.debug("Start  mt.setPostCategories ... categories = #{categories}") if @logger && @logger.debug?
				result = client.call(
					"mt.setPostCategories",
					postid, @username, @password,
					(__get_category_array(categories, category_map, errors, warnings) + __get_category_array(autocategory, category_map, errors, warnings)).uniq)
				@logger.debug("Finish mt.setPostCategories") if @logger && @logger.debug?
			rescue => e
				@logger.error("カテゴリの設定に失敗しました。") if @logger
				@logger.error(e) if @logger
				errors.push(WeblogPluginError.new(
					"カテゴリ設定エラー(メッセージ = #{e.message})",
					"カテゴリの設定に失敗しました(メッセージ = #{e.message})。"))
			end
		end

		return [errors, warnings]
	end

	# ブログ記事の再構築を行う
	def __publish_post(client, postid, errors, warnings)
		begin
			@logger.debug("Start  mt.publishPost ... postid = #{postid}") if @logger && @logger.debug?
			result = client.call("mt.publishPost", postid, @username, @password)
			@logger.debug("Finish mt.publishPost ...") if @logger && @logger.debug?
		rescue => e
			@logger.error("記事の再構築に失敗しました。") if @logger
			@logger.error(e) if @logger
			errors.push(WeblogPluginError.new(
				"記事の再構築エラー(メッセージ = #{e.message})",
				"ブログ記事の再構築に失敗しました(メッセージ = #{e.message})。"))
		end
	end

	def __get_category_map(categories, errors, warnings)
		result = {}
		# カテゴリ名はカテゴリＩＤにマップする
		categories.each do |category|
			result[category['categoryId']] = category['categoryId']
		end

		# カテゴリＩＤはそのままカテゴリＩＤにマップする
		#
		# （※）
		# このカテゴリマップ作成の順番は、
		# カテゴリ名にカテゴリＩＤと重複するものが存在する場合、カテゴリ名を優先するということを意味する。
		# 恐らくはレアケースと思われるが、人間へのわかりやすさという観点からそう決定する。
		categories.each do |category|
			result[category['categoryName']] = category['categoryId']
		end
		return result
	end

	def __get_category_array(categories, category_map, errors, warnings)
		result = []

		if categories then
			categories.split(",").each do |category|
				if category_map.has_key?(category) then
					result.push({"categoryId" => category_map[category]})
				else
					warnings.push(WeblogPluginError.new(
						"カテゴリ不在(カテゴリ = #{category})",
						"カテゴリが存在しませんでした(カテゴリ = #{category})。"))
				end
			end
		end

		return result
	end

	# メディア URL を適切な値に変換する
	# この URL 変換が意味を持つのは「公開パス」→「ブログURL」の末尾を '/' で終わらせなかった場合である。
	# 設定画面のコメント上には '/' で終わる旨の説明はあるが、設定時のチェックなどは無く、良くある設定ミスと考える。
	# よくあるミスをたったこれだけの記述で回避できるならばということで本メソッドを実装した。
	def transform_media_url(media_url, media_name)
		if %r!^(.+?)(/?)#{media_name}$! =~ media_url then
			return "#{$1}/#{media_name}"
		else
			return media_url
		end
	end

end
