# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/t_diary/t_diary_formatter'

M2W_WEBLOG_TDIARY_XMLRPC_ENCODING = 'UTF-8'

#=tDiary のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: t_diary.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TDiary_WeblogPlugin < MetaWeblog_WeblogPlugin

	def create_formatter
		return TDiaryFormatter.new(@plugin_manager)
	end

	def create_client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_TDIARY_XMLRPC_ENCODING))
		return result
	end



	def get_article(client, postid)
		@logger.debug("Start  metaWeblog.getPost ... postid = #{postid}") if @logger && @logger.debug?
		post = client.call("metaWeblog.getPost", postid, @username, @password)
		@logger.debug("Finish metaWeblog.getPost ... result = #{post.to_s}") if @logger && @logger.debug?

		if post['description'] == nil then
			raise WeblogPluginError.new(
				"本文取得エラー",
				"本文の取得に失敗しました。"
			)
		end

		if post['link'] == nil then
			raise WeblogPluginError.new(
				"リンク取得エラー",
				"リンクの取得に失敗しました。"
			)
		end

		return [post, post['description'], translate_link(post['link']), post['title']]
	end

	def translate_link(link)
		if link =~ %r!^(.+?)/([0-9]+?)\.html#(p[0-9]+?)$! then
			return "#{$1}/?date=#{$2}##{$3}"
		else
			return link
		end
	end



	def delete_article(client, postid)
		@logger.debug("Start  blogger.deletePost ... postid = #{postid}") if @logger && @logger.debug?
		result = client.call("blogger.deletePost", "", postid, @username, @password)
		@logger.debug("Finish blogger.deletePost ... result = #{result}") if @logger && @logger.debug?

		return result
	end

end
