# coding: UTF-8

require 'xmlrpc_support/xmlrpc_parser'
require 'plugin/weblog/movable_type/movable_type'
require 'plugin/weblog/word_press/word_press_formatter'

M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_WORDPRESS_THUMBNAIL_ROOT_PATH = 'thumbs'
M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING = 'UTF-8'

#=WordPress のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: word_press.rb 1032 2013-07-30 06:13:56Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011 - 2013. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WordPress_WeblogPlugin < MovableType_WeblogPlugin

	def initialize(
			endpoint = M2W_WEBLOG_ENDPOINT,
			username = M2W_WEBLOG_USERNAME,
			password = M2W_WEBLOG_PASSWORD,
			blogid = M2W_WEBLOG_BLOGID,
			attachment_root_path = M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH,
			thumbnail_root_path = M2W_WEBLOG_WORDPRESS_THUMBNAIL_ROOT_PATH)
		super
	end

	def header_alias
		result = super
		return result.merge({
			'keys' => 'mt_keywords',
			'tags' => 'mt_keywords',
			'cats' => M2W_WEBLOG_MT_CATEGORIES
		})
	end

	def create_client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING))
		return result
	end

	def create_formatter
		return WordPressFormatter.new(@plugin_manager)
	end

	# 日付を文字列に直します。
	def get_date(date)
		date = date.clone
		date.gmtime
		return date
	end

	# 添付ファイルのデフォルトのパスを取得します。
	def get_attachment_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@attachment_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end

	# サムネイルのデフォルトのパスを取得します。
	def get_thumbnail_default_filepath(postid, dateCreated, attachment_index, attachment_filename)
		return "#{@thumbnail_root_path}#{postid}_#{attachment_index}#{File.extname(attachment_filename)}"
	end



	def before_post(client, request, response)
		super

		request.header.delete('mt_tb_ping_urls')
	end

	def after_post(client, request, response)
		__set_post_categories(client, response[:postid], response[:categories], @plugin_manager.get_weblog_autocategories, response.errors, response.warnings)
		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end



	def before_edit(client, request, response)
		super

		request.header.delete('mt_tb_ping_urls')
	end

	def after_edit(client, request, response)
		__set_post_categories(client, response[:postid], response[:categories], @plugin_manager.get_weblog_autocategories, response.errors, response.warnings)
		request_trackback(client, request.header, response[:postid], response[:formatted_contents]['description'], response.errors, response.warnings)
	end


end
