/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class Tool_Status_IO {
    private String filename;
    private final String EXECUTING = "EXECUTING";
    private final String ENDwaiting = "END waiting";
    private final String END = "END";
    private final String PAUSEwaiting = "PAUSE waiting";
    private final String PAUSE = "PAUSE";
    private String status;

    public Tool_Status_IO(String filename) {
        this.filename = filename;
    }

    private void loadXml() {
        FileInputStream is = null;
        BufferedInputStream bis = null;
        XMLDecoder xml = null;
        File fl = new File(this.filename);
        if (!fl.exists()) {
            this.status = "END";
            return;
        }
        int i = 0;
        while (i < 3) {
            boolean success = false;
            try {
                try {
                    is = new FileInputStream(this.filename);
                    bis = new BufferedInputStream(is);
                    xml = new XMLDecoder(bis);
                    this.status = (String)xml.readObject();
                    success = true;
                }
                catch (Exception e) {
                    if (i > 1) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    xml.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                if (success) {
                    return;
                }
            }
            this.sleep();
            ++i;
        }
    }

    public void saveXml() {
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        XMLEncoder xml = null;
        try {
            try {
                os = new FileOutputStream(this.filename);
                bos = new BufferedOutputStream(os);
                xml = new XMLEncoder(bos);
                xml.writeObject(this.status);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                xml.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public boolean getExecute() {
        this.loadXml();
        return this.status.equals("EXECUTING");
    }

    public boolean getEnd() {
        this.loadXml();
        return this.status.equals("END");
    }

    public boolean getEndWait() {
        this.loadXml();
        return this.status.equals("END waiting");
    }

    public void setExecute() {
        this.status = "EXECUTING";
        this.saveXml();
    }

    public void setEnd() {
        this.status = "END";
        this.saveXml();
    }

    public void setEndWait() {
        this.status = "END waiting";
        this.saveXml();
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getStatus() {
        return this.status;
    }

    public void setPause() {
        this.status = "PAUSE";
        this.saveXml();
    }

    public boolean getPAUSE() {
        this.loadXml();
        return this.status.equals("PAUSE");
    }

    public void setPauseWait() {
        this.status = "PAUSE waiting";
        this.saveXml();
    }

    public boolean getPauseWait() {
        this.loadXml();
        return this.status.equals("PAUSE waiting");
    }
}

