/*
 * Decompiled with CFR 0.152.
 */
package make_analysis_report;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import structure.File_and_Directory_Address;
import structure.Struct_Community_Digest;
import structure.Struct_CostBar;
import structure.Struct_Cost_AnalysisBar;
import structure.Struct_Cost_Analysis_Digest;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Digest;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Community_digest_ALL_IO;
import tool.Tool_Cost_Analysis_Digest_IO;
import tool.Tool_Cost_Detail_Calculate;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Digest_Calculate;
import tool.Tool_Cost_Digest_IO;
import tool.Tool_Entry_Project_IO;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Make_analysis_report_Main {
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    Tool_User_IO user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
    Struct_User su = this.user_info.getStruct_User();

    public static void main(String[] args) {
        String yyyymm = null;
        String project = null;
        boolean timestamp = false;
        int i = 0;
        while (i < args.length) {
            if ("--yyyymm".equals(args[i])) {
                yyyymm = args[++i];
            } else if ("--project".equals(args[i])) {
                project = args[++i];
            } else if ("--timestamp".equals(args[i])) {
                timestamp = true;
            } else {
                System.out.println("\u5f15\u6570\u6307\u5b9a\u306e\u8aa4\u308a\uff1a\u672a\u77e5\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
                System.exit(0);
            }
            ++i;
        }
        if (project != null && yyyymm != null) {
            Make_analysis_report_Main submit = new Make_analysis_report_Main(project, yyyymm);
        } else if (yyyymm != null) {
            Make_analysis_report_Main make_analysis_report_Main = new Make_analysis_report_Main(yyyymm, timestamp);
        }
        System.exit(0);
    }

    Make_analysis_report_Main(String yyyymm, boolean timestamp) {
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "start");
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "yyyymm=" + yyyymm);
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        Tool_Entry_Project_IO tep = new Tool_Entry_Project_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_project_info());
        tep.loadXml();
        String[] array_project = tep.get_project();
        int i = 0;
        while (i < array_project.length) {
            this.make_report(array_project[i], yyyymm);
            ++i;
        }
        this.user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        this.user_info.getStruct_User().setLastbatchtimestamp(System.currentTimeMillis());
        this.user_info.saveXml();
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
    }

    Make_analysis_report_Main(String project, String yyyymm) {
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "start");
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "project=" + project + " yyyymm=" + yyyymm);
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.make_report(project, yyyymm);
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
    }

    private void make_report(String project, String yyyymm) {
        Struct_CostBar ateval_cost_bar;
        Struct_CostBar eval_value_cost_bar;
        Struct_CostBar recieve_cost_bar;
        Struct_CostBar send_cost_bar;
        Struct_Cost_Digest scd;
        Struct_CostBar ateval_cost_bar2;
        Struct_CostBar eval_value_cost_bar2;
        Struct_CostBar total_cost_bar;
        Struct_CostBar recieve_cost_bar2;
        Struct_CostBar send_cost_bar2;
        int gendate_int;
        Serializable scd2;
        ArrayList<Struct_Cost_Digest> arraylist_tcd_period;
        ArrayList arraylist_tcd;
        Tool_Cost_Detail_IO tcd;
        SimpleDateFormat dfm;
        Tool_Cost_Digest_IO tt;
        double sum_write_cost = 0.0;
        double sum_read_cost = 0.0;
        double sum_toMe_eval = 0.0;
        double sum_toOther_eval = 0.0;
        File fl = new File(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getDir_costrecive());
        Tool_FileFilter ff = new Tool_FileFilter();
        ff.setPrefix(this.addr.getFile_cost_suffix());
        File[] files = fl.listFiles(ff);
        Tool_Community_digest_ALL_IO com_dig = new Tool_Community_digest_ALL_IO();
        com_dig = new Tool_Community_digest_ALL_IO(project);
        com_dig.loadXml();
        if (files != null && files.length > 0) {
            tt = new Tool_Cost_Digest_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getFs() + this.addr.getDir_costanalysis() + this.addr.getFs() + yyyymm + this.addr.getPrefix_recieve());
            tt.Initialize();
            int j = 0;
            while (j < files.length) {
                int lastdate_int;
                long lastdate = files[j].lastModified();
                dfm = new SimpleDateFormat("yyyyMM");
                int yyyymm_int = Integer.valueOf(yyyymm);
                if (yyyymm_int <= (lastdate_int = Integer.valueOf(dfm.format(lastdate)).intValue())) {
                    tcd = new Tool_Cost_Detail_IO(files[j].getAbsolutePath());
                    tcd.loadXml();
                    arraylist_tcd = tcd.getArray_cost_detail();
                    arraylist_tcd_period = new ArrayList<Struct_Cost_Digest>();
                    int k = 0;
                    while (k < arraylist_tcd.size()) {
                        scd2 = (Struct_Cost_Detail)arraylist_tcd.get(k);
                        gendate_int = Integer.valueOf(dfm.format(((Struct_Cost_Detail)scd2).getGeneration_date()));
                        if (yyyymm_int == gendate_int) {
                            sum_read_cost += ((Struct_Cost_Detail)scd2).getRecieve_cost().getCost();
                            sum_toOther_eval += ((Struct_Cost_Detail)scd2).getEval_value();
                            arraylist_tcd_period.add((Struct_Cost_Digest)scd2);
                        }
                        ++k;
                    }
                    if (arraylist_tcd_period.size() > 0) {
                        Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(arraylist_tcd_period);
                        tcdc.Caluculate();
                        scd2 = new Struct_Cost_Digest();
                        Struct_Community_Digest scd_ref = com_dig.getCommunity_Digest(((Struct_Cost_Detail)((Object)arraylist_tcd_period.get(0))).getUserid(), ((Struct_Cost_Detail)((Object)arraylist_tcd_period.get(0))).getSend_number_original());
                        ((Struct_Cost_Digest)scd2).setSender(scd_ref.getSender());
                        ((Struct_Cost_Digest)scd2).setSendnumber(scd_ref.getSendnumber());
                        ((Struct_Cost_Digest)scd2).setSubject(scd_ref.getSubject());
                        ((Struct_Cost_Digest)scd2).setSend_date(scd_ref.getSend_date());
                        send_cost_bar2 = new Struct_CostBar();
                        send_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getSend_cost()));
                        send_cost_bar2.setRealvalue(tcdc.getSend_cost());
                        send_cost_bar2.setMode(this.su.getMode(tcdc.getSend_cost()));
                        ((Struct_Cost_Digest)scd2).setSend_cost(send_cost_bar2);
                        recieve_cost_bar2 = new Struct_CostBar();
                        recieve_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getRecieve_cost()));
                        recieve_cost_bar2.setRealvalue(tcdc.getRecieve_cost());
                        recieve_cost_bar2.setMode(this.su.getMode(tcdc.getRecieve_cost()));
                        ((Struct_Cost_Digest)scd2).setRecieve_cost(recieve_cost_bar2);
                        total_cost_bar = new Struct_CostBar();
                        total_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getTotal_cost()));
                        total_cost_bar.setRealvalue(tcdc.getTotal_cost());
                        total_cost_bar.setMode(this.su.getMode(tcdc.getTotal_cost()));
                        ((Struct_Cost_Digest)scd2).setTotal_cost(total_cost_bar);
                        eval_value_cost_bar2 = new Struct_CostBar();
                        eval_value_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getEval_value()));
                        eval_value_cost_bar2.setRealvalue(tcdc.getEval_value());
                        eval_value_cost_bar2.setMode(this.su.getMode(tcdc.getEval_value()));
                        ((Struct_Cost_Digest)scd2).setEval_value(eval_value_cost_bar2);
                        ateval_cost_bar2 = new Struct_CostBar();
                        ateval_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getAtvalue_cost()));
                        ateval_cost_bar2.setRealvalue(tcdc.getAtvalue_cost());
                        ateval_cost_bar2.setMode(this.su.getMode(tcdc.getAtvalue_cost()));
                        ((Struct_Cost_Digest)scd2).setAteval_cost(ateval_cost_bar2);
                        ((Struct_Cost_Digest)scd2).setFilename(String.valueOf(this.addr.getFile_cost_suffix()) + scd_ref.getFilename());
                        tt.insertData((Struct_Cost_Digest)scd2);
                    }
                }
                ++j;
            }
            Tool_Cost_Digest_Calculate tcdc = new Tool_Cost_Digest_Calculate(tt.getdata());
            tcdc.Caluculate();
            scd = new Struct_Cost_Digest();
            scd.setSender("***\u5408\u8a08***");
            scd.setSendnumber("99999");
            scd.setSubject("***\u53d7\u4fe1\u30e1\u30fc\u30eb***");
            send_cost_bar = new Struct_CostBar();
            send_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getSend_cost()));
            send_cost_bar.setRealvalue(tcdc.getSend_cost());
            send_cost_bar.setMode(this.su.getMode(tcdc.getSend_cost()));
            scd.setSend_cost(send_cost_bar);
            recieve_cost_bar = new Struct_CostBar();
            recieve_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getRecieve_cost()));
            recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
            recieve_cost_bar.setMode(this.su.getMode(tcdc.getRecieve_cost()));
            scd.setRecieve_cost(recieve_cost_bar);
            Struct_CostBar total_cost_bar2 = new Struct_CostBar();
            total_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getTotal_cost()));
            total_cost_bar2.setRealvalue(tcdc.getTotal_cost());
            total_cost_bar2.setMode(this.su.getMode(tcdc.getTotal_cost()));
            scd.setTotal_cost(total_cost_bar2);
            eval_value_cost_bar = new Struct_CostBar();
            eval_value_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getEval_value()));
            eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
            eval_value_cost_bar.setMode(this.su.getMode(tcdc.getEval_value()));
            scd.setEval_value(eval_value_cost_bar);
            ateval_cost_bar = new Struct_CostBar();
            ateval_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getAtvalue_cost()));
            ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
            ateval_cost_bar.setMode(this.su.getMode(tcdc.getAtvalue_cost()));
            scd.setAteval_cost(ateval_cost_bar);
            tt.insertLastData(scd);
            tt.saveXml();
        }
        fl = new File(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getDir_costsend());
        ff = new Tool_FileFilter();
        ff.setPrefix(this.addr.getFile_cost_suffix());
        files = fl.listFiles(ff);
        if (files != null && files.length > 0) {
            tt = new Tool_Cost_Digest_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getFs() + this.addr.getDir_costanalysis() + this.addr.getFs() + yyyymm + this.addr.getPrefix_send());
            tt.Initialize();
            int j = 0;
            while (j < files.length) {
                int lastdate_int;
                long lastdate = files[j].lastModified();
                dfm = new SimpleDateFormat("yyyyMM");
                int yyyymm_int = Integer.valueOf(yyyymm);
                if (yyyymm_int <= (lastdate_int = Integer.valueOf(dfm.format(lastdate)).intValue())) {
                    tcd = new Tool_Cost_Detail_IO(files[j].getAbsolutePath());
                    tcd.loadXml();
                    arraylist_tcd = tcd.getArray_cost_detail();
                    arraylist_tcd_period = new ArrayList();
                    int k = 0;
                    while (k < arraylist_tcd.size()) {
                        scd2 = (Struct_Cost_Detail)arraylist_tcd.get(k);
                        gendate_int = Integer.valueOf(dfm.format(((Struct_Cost_Detail)scd2).getGeneration_date()));
                        if (yyyymm_int == gendate_int) {
                            if (this.su.getUserid().equals(((Struct_Cost_Detail)scd2).getGeneration_userid())) {
                                sum_write_cost += ((Struct_Cost_Detail)scd2).getSend_cost().getCost();
                                sum_read_cost += ((Struct_Cost_Detail)scd2).getRecieve_cost().getCost();
                            } else {
                                sum_toMe_eval += ((Struct_Cost_Detail)scd2).getEval_value();
                            }
                            arraylist_tcd_period.add((Struct_Cost_Digest)scd2);
                        }
                        ++k;
                    }
                    if (arraylist_tcd_period.size() > 0) {
                        Tool_Cost_Detail_Calculate tcdc = new Tool_Cost_Detail_Calculate(arraylist_tcd_period);
                        tcdc.Caluculate();
                        scd2 = new Struct_Cost_Digest();
                        Struct_Community_Digest scd_ref = com_dig.getCommunity_Digest(((Struct_Cost_Detail)((Object)arraylist_tcd_period.get(0))).getUserid(), ((Struct_Cost_Detail)((Object)arraylist_tcd_period.get(0))).getSend_number_original());
                        ((Struct_Cost_Digest)scd2).setSender(scd_ref.getSender());
                        ((Struct_Cost_Digest)scd2).setSendnumber(scd_ref.getSendnumber());
                        ((Struct_Cost_Digest)scd2).setSubject(scd_ref.getSubject());
                        ((Struct_Cost_Digest)scd2).setSend_date(scd_ref.getSend_date());
                        send_cost_bar2 = new Struct_CostBar();
                        send_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getSend_cost()));
                        send_cost_bar2.setRealvalue(tcdc.getSend_cost());
                        send_cost_bar2.setMode(this.su.getMode(tcdc.getSend_cost()));
                        ((Struct_Cost_Digest)scd2).setSend_cost(send_cost_bar2);
                        recieve_cost_bar2 = new Struct_CostBar();
                        recieve_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getRecieve_cost()));
                        recieve_cost_bar2.setRealvalue(tcdc.getRecieve_cost());
                        recieve_cost_bar2.setMode(this.su.getMode(tcdc.getRecieve_cost()));
                        ((Struct_Cost_Digest)scd2).setRecieve_cost(recieve_cost_bar2);
                        total_cost_bar = new Struct_CostBar();
                        total_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getTotal_cost()));
                        total_cost_bar.setRealvalue(tcdc.getTotal_cost());
                        total_cost_bar.setMode(this.su.getMode(tcdc.getTotal_cost()));
                        ((Struct_Cost_Digest)scd2).setTotal_cost(total_cost_bar);
                        eval_value_cost_bar2 = new Struct_CostBar();
                        eval_value_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getEval_value()));
                        eval_value_cost_bar2.setRealvalue(tcdc.getEval_value());
                        eval_value_cost_bar2.setMode(this.su.getMode(tcdc.getEval_value()));
                        ((Struct_Cost_Digest)scd2).setEval_value(eval_value_cost_bar2);
                        ateval_cost_bar2 = new Struct_CostBar();
                        ateval_cost_bar2.setMaxvalue(this.su.getMaxValue(tcdc.getAtvalue_cost()));
                        ateval_cost_bar2.setRealvalue(tcdc.getAtvalue_cost());
                        ateval_cost_bar2.setMode(this.su.getMode(tcdc.getAtvalue_cost()));
                        ((Struct_Cost_Digest)scd2).setAteval_cost(ateval_cost_bar2);
                        ((Struct_Cost_Digest)scd2).setFilename(String.valueOf(this.addr.getFile_cost_suffix()) + scd_ref.getFilename());
                        tt.insertData((Struct_Cost_Digest)scd2);
                    }
                }
                ++j;
            }
            Tool_Cost_Digest_Calculate tcdc = new Tool_Cost_Digest_Calculate(tt.getdata());
            tcdc.Caluculate();
            scd = new Struct_Cost_Digest();
            scd.setSender("***\u5408\u8a08***");
            scd.setSendnumber("99999");
            scd.setSubject("***\u9001\u4fe1\u30e1\u30fc\u30eb***");
            send_cost_bar = new Struct_CostBar();
            send_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getSend_cost()));
            send_cost_bar.setRealvalue(tcdc.getSend_cost());
            send_cost_bar.setMode(this.su.getMode(tcdc.getSend_cost()));
            scd.setSend_cost(send_cost_bar);
            recieve_cost_bar = new Struct_CostBar();
            recieve_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getRecieve_cost()));
            recieve_cost_bar.setRealvalue(tcdc.getRecieve_cost());
            recieve_cost_bar.setMode(this.su.getMode(tcdc.getRecieve_cost()));
            scd.setRecieve_cost(recieve_cost_bar);
            Struct_CostBar total_cost_bar3 = new Struct_CostBar();
            total_cost_bar3.setMaxvalue(this.su.getMaxValue(tcdc.getTotal_cost()));
            total_cost_bar3.setRealvalue(tcdc.getTotal_cost());
            total_cost_bar3.setMode(this.su.getMode(tcdc.getTotal_cost()));
            scd.setTotal_cost(total_cost_bar3);
            eval_value_cost_bar = new Struct_CostBar();
            eval_value_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getEval_value()));
            eval_value_cost_bar.setRealvalue(tcdc.getEval_value());
            eval_value_cost_bar.setMode(this.su.getMode(tcdc.getEval_value()));
            scd.setEval_value(eval_value_cost_bar);
            ateval_cost_bar = new Struct_CostBar();
            ateval_cost_bar.setMaxvalue(this.su.getMaxValue(tcdc.getAtvalue_cost()));
            ateval_cost_bar.setRealvalue(tcdc.getAtvalue_cost());
            ateval_cost_bar.setMode(this.su.getMode(tcdc.getAtvalue_cost()));
            scd.setAteval_cost(ateval_cost_bar);
            tt.insertLastData(scd);
            tt.saveXml();
        }
        double sum_real_cost = sum_write_cost + sum_read_cost;
        double sum_cont_cost = sum_toMe_eval - sum_toOther_eval;
        double sum_total_cost = sum_real_cost - sum_cont_cost;
        Struct_Cost_Analysis_Digest scad = new Struct_Cost_Analysis_Digest();
        scad.setYyyymm(yyyymm);
        Struct_Cost_AnalysisBar write_costBar = new Struct_Cost_AnalysisBar();
        write_costBar.setRealvalue((int)sum_write_cost);
        write_costBar.setMaxvalue(this.su.getWrite_maxcost());
        scad.setWrite_cost(write_costBar);
        Struct_Cost_AnalysisBar read_costBar = new Struct_Cost_AnalysisBar();
        read_costBar.setRealvalue((int)sum_read_cost);
        read_costBar.setMaxvalue(this.su.getRead_maxcost());
        scad.setRead_cost(read_costBar);
        Struct_Cost_AnalysisBar real_costBar = new Struct_Cost_AnalysisBar();
        real_costBar.setRealvalue((int)sum_real_cost);
        real_costBar.setMaxvalue(this.su.getReal_maxcost());
        scad.setReal_cost(real_costBar);
        Struct_Cost_AnalysisBar toMe_evalBar = new Struct_Cost_AnalysisBar();
        toMe_evalBar.setRealvalue((int)sum_toMe_eval);
        toMe_evalBar.setMaxvalue(this.su.getMy_eval_maxcost());
        scad.setToMe_eval(toMe_evalBar);
        Struct_Cost_AnalysisBar toOther_evalBar = new Struct_Cost_AnalysisBar();
        toOther_evalBar.setRealvalue((int)sum_toOther_eval);
        toOther_evalBar.setMaxvalue(this.su.getOther_eval_maxcost());
        scad.setToOther_eval(toOther_evalBar);
        Struct_Cost_AnalysisBar cont_costBar = new Struct_Cost_AnalysisBar();
        cont_costBar.setRealvalue((int)sum_cont_cost);
        cont_costBar.setMaxvalue(this.su.getCont_maxcost());
        scad.setCont_cost(cont_costBar);
        Struct_Cost_AnalysisBar total_costBar = new Struct_Cost_AnalysisBar();
        total_costBar.setRealvalue((int)sum_total_cost);
        total_costBar.setMaxvalue(this.su.getTotal_maxcost());
        scad.setTotal_cost(total_costBar);
        long nowtime = System.currentTimeMillis();
        scad.setBatch_date(nowtime);
        scad.setFilename_send(String.valueOf(yyyymm) + this.addr.getPrefix_send());
        scad.setFilename_recieve(String.valueOf(yyyymm) + this.addr.getPrefix_recieve());
        Tool_Cost_Analysis_Digest_IO t = new Tool_Cost_Analysis_Digest_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + project + this.addr.getDir_costanalysis() + this.addr.getFile_cost_digest());
        t.loadXml();
        int search = t.getLine(yyyymm);
        if (search == -1) {
            t.insertData_asc(scad);
        } else {
            t.replaceData(search, scad);
        }
        t.saveXml();
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

