/*
 * Decompiled with CFR 0.152.
 */
package socket_client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import socket_client.Client_Cost_Send;
import socket_client.Client_Mail_Send;
import socket_client.Client_Recieve;
import structure.File_and_Directory_Address;
import structure.Struct_Relay_Node;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_FileFilter;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;
import tool.Tool_Task_Socket;
import tool.Tool_User_IO;

public class Client_Main {
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    String mode;
    String suffix;
    boolean relay = false;
    boolean server = false;
    String project;
    String userid;
    String address;
    long lastupdate;
    String dir;
    boolean send_direct;
    boolean send_direct_option;
    boolean send_direct_option_relay;
    boolean send_direct_option_server;
    ArrayList<Struct_Relay_Node> asrn = new ArrayList();

    public static void main(String[] args) {
        String mode = null;
        String prefix = null;
        String suffix = null;
        boolean relay = false;
        boolean server = false;
        String project = null;
        int i = 0;
        while (i < args.length) {
            if ("--mode".equals(args[i])) {
                mode = args[++i];
            } else if ("--prefix".equals(args[i])) {
                prefix = args[++i];
            } else if ("--suffix".equals(args[i])) {
                suffix = args[++i];
            } else if ("--relay".equals(args[i])) {
                relay = true;
            } else if ("--server".equals(args[i])) {
                server = true;
            } else if ("--project".equals(args[i])) {
                project = args[++i];
            } else {
                System.out.println("\u5f15\u6570\u6307\u5b9a\u306e\u8aa4\u308a\uff1a\u672a\u77e5\u306e\u5f15\u6570\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
                System.exit(-1);
            }
            ++i;
        }
        if (mode.equals("target")) {
            Client_Main submit = new Client_Main(mode, prefix, suffix, relay, server);
            System.exit(0);
        } else if (mode.equals("all")) {
            Client_Main submit = new Client_Main(mode, null, suffix, relay, server);
            System.exit(0);
        } else if (mode.equals("server")) {
            Client_Main submit = new Client_Main(project);
            System.exit(0);
        }
    }

    Client_Main(String project) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.project = project;
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "start");
        Client_Recieve cr = new Client_Recieve(project);
        cr.recieve();
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
    }

    Client_Main(String mode, String prefix, String suffix, boolean relay, boolean server) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "start");
        this.mode = mode;
        this.suffix = suffix;
        this.relay = relay;
        this.server = server;
        Tool_Task_Socket tts = new Tool_Task_Socket();
        tts.sendTaskBorn();
        int timer = tts.getMax_timer();
        while (true) {
            byte code;
            if ((code = tts.submit_Judgment()) == 0) {
                this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "Forced ending instruction");
                this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
                System.exit(0);
            } else if (code == 2) break;
            if (timer < 0) {
                this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "wait time over " + tts.getInterval() * tts.getMax_timer() + "minutes");
                this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
                System.exit(0);
            }
            try {
                Thread.sleep(tts.getInterval() * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
            --timer;
        }
        this.user_get();
        this.dir = !relay ? String.valueOf(this.addr.getDir_current()) + this.addr.getDir_buff_send() : String.valueOf(this.addr.getDir_current()) + this.addr.getDir_buff_relay();
        File fl = new File(this.dir);
        Tool_FileFilter ff = new Tool_FileFilter();
        if (mode.equals("target")) {
            ff.setPrefix(prefix);
        }
        ff.setSuffix(suffix);
        File[] files = fl.listFiles(ff);
        int i = 0;
        while (i < files.length) {
            byte sendkind = this.sendkind(files[i].getName());
            if (sendkind == 1) {
                Client_Mail_Send sms = new Client_Mail_Send(mode, this.dir, suffix, this.send_direct, this.send_direct_option, this.send_direct_option_relay, this.send_direct_option_server, this.asrn, relay, server);
                sms.mailsend(fl, files[i].getPath(), ff, files, i);
            } else if (sendkind == 2) {
                Client_Cost_Send scs = new Client_Cost_Send(mode, this.dir, suffix, this.send_direct, this.send_direct_option, this.send_direct_option_relay, this.send_direct_option_server, this.asrn, relay, server);
                scs.costsend(fl, files[i].getPath(), ff, files, i);
            }
            ++i;
        }
        tts.sendTaskDead();
        this.logout.out(this.sysconfig.getLogmode3(), this.getClass().getName(), "end");
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
            this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
        }
    }

    private byte sendkind(String filename) {
        if (filename.substring(0, 1).equals("C")) {
            return 2;
        }
        return 1;
    }

    private void user_get() {
        Tool_User_IO user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        Struct_User su = user_info.getStruct_User();
        this.send_direct = su.isSend_direct();
        this.send_direct_option = su.isSend_direct_option();
        this.send_direct_option_relay = su.isSend_direct_option_relay();
        this.send_direct_option_server = su.isSend_direct_option_server();
        if (!this.send_direct || this.send_direct_option && this.send_direct_option_relay) {
            Struct_Relay_Node srn;
            if (su.getRelay1_node() != null && su.getRelay1_node().length() > 0) {
                srn = new Struct_Relay_Node();
                srn.setUserid(su.getRelay1_userid());
                srn.setNode(su.getRelay1_node());
                srn.setProject(su.getRelay1_project());
                srn.setCommunity(su.getRelay1_community());
                this.asrn.add(srn);
            }
            if (su.getRelay2_node() != null && su.getRelay2_node().length() > 0) {
                srn = new Struct_Relay_Node();
                srn.setUserid(su.getRelay2_userid());
                srn.setNode(su.getRelay2_node());
                srn.setProject(su.getRelay2_project());
                srn.setCommunity(su.getRelay2_community());
                this.asrn.add(srn);
            }
            if (su.getRelay3_node() != null && su.getRelay3_node().length() > 0) {
                srn = new Struct_Relay_Node();
                srn.setUserid(su.getRelay3_userid());
                srn.setNode(su.getRelay3_node());
                srn.setProject(su.getRelay3_project());
                srn.setCommunity(su.getRelay3_community());
                this.asrn.add(srn);
            }
            if (su.getRelay4_node() != null && su.getRelay4_node().length() > 0) {
                srn = new Struct_Relay_Node();
                srn.setUserid(su.getRelay4_userid());
                srn.setNode(su.getRelay4_node());
                srn.setProject(su.getRelay4_project());
                srn.setCommunity(su.getRelay4_community());
                this.asrn.add(srn);
            }
            if (su.getRelay5_node() != null && su.getRelay5_node().length() > 0) {
                srn = new Struct_Relay_Node();
                srn.setUserid(su.getRelay5_userid());
                srn.setNode(su.getRelay5_node());
                srn.setProject(su.getRelay5_project());
                srn.setCommunity(su.getRelay5_community());
                this.asrn.add(srn);
            }
        }
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

