/*
 * Decompiled with CFR 0.152.
 */
package report_cost;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import structure.File_and_Directory_Address;
import structure.Struct_Community_Menber;
import structure.Struct_CostBar;
import structure.Struct_Cost_Detail;
import structure.Struct_Cost_Report;
import structure.Struct_Cost_Source;
import structure.Struct_Format_Numeric;
import structure.Struct_System_Config;
import structure.Struct_User;
import tool.Tool_Community_Menber_IO;
import tool.Tool_Cost_Detail_IO;
import tool.Tool_Cost_Report_Calculate;
import tool.Tool_LogOut;
import tool.Tool_SortableTableModel;
import tool.Tool_System_Config_IO;
import tool.Tool_User_IO;

public class Gui_Report_Cost_Main
extends JFrame
implements ComponentListener {
    JPanel contentPane;
    JScrollPane src;
    JTable table;
    String dir;
    String file;
    String project;
    String yyyymm;
    ArrayList arraylist;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());
    Struct_Format_Numeric form_change = new Struct_Format_Numeric();

    Gui_Report_Cost_Main(String mode, String dir, String file, String project, String sendnumber, String subject, String senddate, String sender, String yyyymm) {
        Tool_SortableTableModel sortModel;
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "mode      :" + mode);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "dir       :" + dir);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "file      :" + file);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "project   :" + project);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "sendnumber:" + sendnumber);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "subject   :" + subject);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "senddate  :" + senddate);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "sender    :" + sender);
        this.logout.out(this.sysconfig.getLogmode4(), this.getClass().getName(), "yyyymm    :" + yyyymm);
        this.setTitle("\u30b3\u30b9\u30c8\u30ec\u30dd\u30fc\u30c8");
        this.setSize(700, 300);
        this.setLocation(100, 100);
        this.dir = dir;
        this.file = file;
        this.project = project;
        this.yyyymm = yyyymm;
        this.loadXml();
        if (yyyymm != null && yyyymm.length() > 0) {
            this.arraylist = this.yyyymm_Exclude(this.arraylist);
        }
        if (this.arraylist == null || this.arraylist.size() == 0) {
            sortModel = new Tool_SortableTableModel(new Struct_Cost_Report().getColData(), 0);
        } else {
            ArrayList outlist = null;
            outlist = mode.equals("normal") ? this.direct_Set(this.arraylist) : this.direct_Set(this.userGroup_Set(this.arraylist));
            Object[][] Objdata = this.getObj(outlist);
            sortModel = new Tool_SortableTableModel(Objdata, new Struct_Cost_Report().getColData());
        }
        this.table = new JTable();
        this.table.setModel(sortModel);
        sortModel.addMouseListenerToHeaderInTable(this.table);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        col.setCellRenderer(renderer);
        col.setPreferredWidth(35);
        int i = 3;
        while (i < 8) {
            col = this.table.getColumnModel().getColumn(i);
            col.setCellRenderer(new Struct_CostBar());
            ++i;
        }
        if (yyyymm != null && yyyymm.length() > 0 && this.table.getRowCount() != 0) {
            int row = this.table.getRowCount() - 1;
            Struct_CostBar w_cell = (Struct_CostBar)this.table.getValueAt(row, 3);
            w_cell.setOutline((byte)103);
            this.table.setValueAt(w_cell, row, 3);
            w_cell = (Struct_CostBar)this.table.getValueAt(row, 4);
            w_cell.setOutline((byte)113);
            this.table.setValueAt(w_cell, row, 4);
            w_cell = (Struct_CostBar)this.table.getValueAt(row, 5);
            w_cell.setOutline((byte)113);
            this.table.setValueAt(w_cell, row, 5);
            w_cell = (Struct_CostBar)this.table.getValueAt(row, 6);
            w_cell.setOutline((byte)113);
            this.table.setValueAt(w_cell, row, 6);
            w_cell = (Struct_CostBar)this.table.getValueAt(row, 7);
            w_cell.setOutline((byte)123);
            this.table.setValueAt(w_cell, row, 7);
        }
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 3));
        this.contentPane.add(Box.createRigidArea(new Dimension(10, 10)));
        JLabel lbl1 = new JLabel();
        lbl1.setText("\u30b3\u30b9\u30c8\u8a73\u7d30\u8868\u793a");
        lbl1.setAlignmentX(0.0f);
        this.contentPane.add(lbl1);
        this.contentPane.add(Box.createRigidArea(new Dimension(10, 10)));
        JLabel lbl2 = new JLabel();
        lbl2.setText("\u9001\u4fe1\u756a\u53f7\uff1a");
        JLabel lbl3 = new JLabel();
        lbl3.setText(sendnumber);
        JPanel pnlSendnumber = new JPanel();
        pnlSendnumber.setLayout(new BoxLayout(pnlSendnumber, 2));
        pnlSendnumber.add(lbl2);
        pnlSendnumber.add(lbl3);
        pnlSendnumber.setAlignmentX(0.0f);
        this.contentPane.add(pnlSendnumber);
        JLabel lbl4 = new JLabel();
        lbl4.setText("\u4ef6\u540d\u3000\u3000\uff1a");
        JLabel lbl5 = new JLabel();
        lbl5.setText(subject);
        JPanel pnlSubject = new JPanel();
        pnlSubject.setLayout(new BoxLayout(pnlSubject, 2));
        pnlSubject.add(lbl4);
        pnlSubject.add(lbl5);
        pnlSubject.setAlignmentX(0.0f);
        this.contentPane.add(pnlSubject);
        JLabel lbl8 = new JLabel();
        lbl8.setText("\u9001\u4fe1\u8005\u3000\uff1a");
        JLabel lbl9 = new JLabel();
        lbl9.setText(sender);
        JPanel pnlSender = new JPanel();
        pnlSender.setLayout(new BoxLayout(pnlSender, 2));
        pnlSender.add(lbl8);
        pnlSender.add(lbl9);
        pnlSender.setAlignmentX(0.0f);
        this.contentPane.add(pnlSender);
        JLabel lbl6 = new JLabel();
        lbl6.setText("\u9001\u4fe1\u65e5\u4ed8\uff1a");
        JLabel lbl7 = new JLabel();
        lbl7.setText(senddate);
        JPanel pnlSenddate = new JPanel();
        pnlSenddate.setLayout(new BoxLayout(pnlSenddate, 2));
        pnlSenddate.add(lbl6);
        pnlSenddate.add(lbl7);
        pnlSenddate.setAlignmentX(0.0f);
        this.contentPane.add(pnlSenddate);
        JLabel lbl10 = new JLabel();
        lbl10.setText("\u5358\u4f4d\uff0f\u5186");
        int height = lbl10.getMaximumSize().height;
        lbl10.setPreferredSize(new Dimension(100, height));
        JPanel pnlUnit = new JPanel();
        pnlUnit.setLayout(new BorderLayout());
        pnlUnit.add((Component)lbl10, "East");
        pnlUnit.setAlignmentX(0.0f);
        this.contentPane.add(pnlUnit);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.src = new JScrollPane(this.table);
        this.src.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.contentPane.add(this.src);
        JLabel statusBar = new JLabel("\u2605\u30ab\u30e9\u30e0\u540d\u3092\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u30bd\u30fc\u30c8\u3057\u307e\u3059");
        Font font = statusBar.getFont();
        statusBar.setFont(new Font(font.getFontName(), 2, font.getSize()));
        statusBar.setForeground(Color.MAGENTA);
        this.contentPane.add((Component)statusBar, "South");
        ImageIcon icon = new ImageIcon(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_icon() + this.addr.getIcon_mailcost());
        this.setIconImage(icon.getImage());
        this.addComponentListener(this);
        this.setVisible(true);
    }

    private void loadXml() {
        Tool_Cost_Detail_IO t = new Tool_Cost_Detail_IO(String.valueOf(this.dir) + this.file);
        t.loadXml();
        this.arraylist = t.getArray_cost_detail();
    }

    public static void main(String[] args) {
        String mode = null;
        String dir = null;
        String file = null;
        String project = null;
        String sendnumber = null;
        String subject = null;
        String senddate = null;
        String sender = null;
        String yyyymm = null;
        int i = 0;
        while (i < args.length) {
            if ("--mode".equals(args[i])) {
                mode = args[++i];
            } else if ("--dir".equals(args[i])) {
                dir = args[++i];
            } else if ("--file".equals(args[i])) {
                file = args[++i];
            } else if ("--project".equals(args[i])) {
                project = args[++i];
            } else if ("--sendnumber".equals(args[i])) {
                sendnumber = args[++i];
            } else if ("--subject".equals(args[i])) {
                subject = args[++i];
            } else if ("--senddate".equals(args[i])) {
                senddate = args[++i];
            } else if ("--sender".equals(args[i])) {
                sender = args[++i];
            } else if ("--yyyymm".equals(args[i])) {
                yyyymm = args[++i];
            }
            ++i;
        }
        Gui_Report_Cost_Main frame = new Gui_Report_Cost_Main(mode, dir, file, project, sendnumber, subject, senddate, sender, yyyymm);
        frame.setDefaultCloseOperation(3);
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    private Object[][] getObj(ArrayList arraylist) {
        Object[][] rtnobj = new Object[arraylist.size()][new Struct_Cost_Report().getColData().length];
        int i = 0;
        while (i < arraylist.size()) {
            Struct_Cost_Report scr = (Struct_Cost_Report)arraylist.get(i);
            rtnobj[i][0] = scr.getNumber();
            rtnobj[i][1] = scr.getName();
            rtnobj[i][2] = scr.getGen_date();
            rtnobj[i][3] = scr.getSend_cost();
            rtnobj[i][4] = scr.getRecieve_cost();
            rtnobj[i][5] = scr.getTotal_cost();
            rtnobj[i][6] = scr.getEval_value();
            rtnobj[i][7] = scr.getAteval_cost();
            ++i;
        }
        return rtnobj;
    }

    private ArrayList direct_Set(ArrayList arraylist) {
        ArrayList<Struct_Cost_Report> outlist = new ArrayList<Struct_Cost_Report>();
        Tool_User_IO user_info = new Tool_User_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_user_info());
        Struct_User su = user_info.getStruct_User();
        Tool_Community_Menber_IO tcm = new Tool_Community_Menber_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getDir_project() + this.project + this.addr.getFs() + this.addr.getFile_com_menber());
        tcm.loadXml();
        ArrayList array_Community_Menber = tcm.getdata();
        int i = 0;
        while (i < arraylist.size()) {
            Struct_Cost_Detail scd_in = (Struct_Cost_Detail)arraylist.get(i);
            Struct_Cost_Report scr_out = new Struct_Cost_Report();
            scr_out.setNumber(i + 1);
            int j = 0;
            while (j < array_Community_Menber.size()) {
                if (((Struct_Community_Menber)array_Community_Menber.get(j)).getUserid().equals(scd_in.getGeneration_userid())) {
                    scr_out.setName(((Struct_Community_Menber)array_Community_Menber.get(j)).getUser_fullname());
                    break;
                }
                ++j;
            }
            scr_out.setGen_date(DateFormat.getDateTimeInstance().format(scd_in.getGeneration_date()));
            Struct_CostBar send_cost_bar = new Struct_CostBar();
            send_cost_bar.setMaxvalue(su.getMaxValue((int)scd_in.getSend_cost().getCost()));
            send_cost_bar.setRealvalue((int)scd_in.getSend_cost().getCost());
            send_cost_bar.setMode(su.getMode((int)scd_in.getSend_cost().getCost()));
            send_cost_bar.setMongon(this.form_change.change_format9_doble(scd_in.getSend_cost().getCost()));
            scr_out.setSend_cost(send_cost_bar);
            Struct_CostBar recieve_cost_bar = new Struct_CostBar();
            recieve_cost_bar.setMaxvalue(su.getMaxValue((int)scd_in.getRecieve_cost().getCost()));
            recieve_cost_bar.setRealvalue((int)scd_in.getRecieve_cost().getCost());
            recieve_cost_bar.setMode(su.getMode((int)scd_in.getRecieve_cost().getCost()));
            recieve_cost_bar.setMongon(this.form_change.change_format9_doble(scd_in.getRecieve_cost().getCost()));
            scr_out.setRecieve_cost(recieve_cost_bar);
            Struct_CostBar total_cost_bar = new Struct_CostBar();
            total_cost_bar.setMaxvalue(su.getMaxValue((int)scd_in.getTotal_cost()));
            total_cost_bar.setRealvalue((int)scd_in.getTotal_cost());
            total_cost_bar.setMode(su.getMode((int)scd_in.getTotal_cost()));
            total_cost_bar.setMongon(this.form_change.change_format9_doble(scd_in.getTotal_cost()));
            scr_out.setTotal_cost(total_cost_bar);
            Struct_CostBar eval_value_cost_bar = new Struct_CostBar();
            eval_value_cost_bar.setMaxvalue(su.getMaxValue((int)scd_in.getEval_value()));
            eval_value_cost_bar.setRealvalue((int)scd_in.getEval_value());
            eval_value_cost_bar.setMode(su.getMode((int)scd_in.getEval_value()));
            eval_value_cost_bar.setMongon(this.form_change.change_format9_doble(scd_in.getEval_value()));
            scr_out.setEval_value(eval_value_cost_bar);
            Struct_CostBar ateval_cost_bar = new Struct_CostBar();
            ateval_cost_bar.setMaxvalue(su.getMaxValue((int)scd_in.getAtvalue_cost()));
            ateval_cost_bar.setRealvalue((int)scd_in.getAtvalue_cost());
            ateval_cost_bar.setMode(su.getMode((int)scd_in.getAtvalue_cost()));
            ateval_cost_bar.setMongon(this.form_change.change_format9_doble(scd_in.getAtvalue_cost()));
            scr_out.setAteval_cost(ateval_cost_bar);
            outlist.add(scr_out);
            ++i;
        }
        Tool_Cost_Report_Calculate tcrc = new Tool_Cost_Report_Calculate(outlist);
        tcrc.Caluculate();
        Struct_Cost_Report scr = new Struct_Cost_Report();
        scr.setNumber(outlist.size() + 1);
        scr.setName("***\u5408\u8a08***");
        Struct_CostBar send_cost_bar = new Struct_CostBar();
        send_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getSend_cost()));
        send_cost_bar.setRealvalue(tcrc.getSend_cost());
        send_cost_bar.setMode(su.getMode(tcrc.getSend_cost()));
        send_cost_bar.setMongon(this.form_change.change_format9_doble(tcrc.getSend_cost()));
        scr.setSend_cost(send_cost_bar);
        Struct_CostBar recieve_cost_bar = new Struct_CostBar();
        recieve_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getRecieve_cost()));
        recieve_cost_bar.setRealvalue(tcrc.getRecieve_cost());
        recieve_cost_bar.setMode(su.getMode(tcrc.getRecieve_cost()));
        recieve_cost_bar.setMongon(this.form_change.change_format9_doble(tcrc.getRecieve_cost()));
        scr.setRecieve_cost(recieve_cost_bar);
        Struct_CostBar total_cost_bar = new Struct_CostBar();
        total_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getTotal_cost()));
        total_cost_bar.setRealvalue(tcrc.getTotal_cost());
        total_cost_bar.setMode(su.getMode(tcrc.getTotal_cost()));
        total_cost_bar.setMongon(this.form_change.change_format9_doble(tcrc.getTotal_cost()));
        scr.setTotal_cost(total_cost_bar);
        Struct_CostBar eval_value_cost_bar = new Struct_CostBar();
        eval_value_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getEval_value()));
        eval_value_cost_bar.setRealvalue(tcrc.getEval_value());
        eval_value_cost_bar.setMode(su.getMode(tcrc.getEval_value()));
        eval_value_cost_bar.setMongon(this.form_change.change_format9_doble(tcrc.getEval_value()));
        scr.setEval_value(eval_value_cost_bar);
        Struct_CostBar ateval_cost_bar = new Struct_CostBar();
        ateval_cost_bar.setMaxvalue(su.getMaxValue(tcrc.getAtvalue_cost()));
        ateval_cost_bar.setRealvalue(tcrc.getAtvalue_cost());
        ateval_cost_bar.setMode(su.getMode(tcrc.getAtvalue_cost()));
        ateval_cost_bar.setMongon(this.form_change.change_format9_doble(tcrc.getAtvalue_cost()));
        scr.setAteval_cost(ateval_cost_bar);
        outlist.add(scr);
        return outlist;
    }

    private ArrayList userGroup_Set(ArrayList arraylist) {
        if (arraylist.size() == 1) {
            return arraylist;
        }
        int i = arraylist.size() - 1;
        while (i > 0) {
            Struct_Cost_Detail scd_add = (Struct_Cost_Detail)arraylist.get(i);
            int found = -1;
            int j = 0;
            while (j < i) {
                if (((Struct_Cost_Detail)arraylist.get(j)).getGeneration_userid().equals(scd_add.getGeneration_userid())) {
                    found = j;
                    break;
                }
                ++j;
            }
            if (found != -1) {
                Struct_Cost_Detail scd_src = (Struct_Cost_Detail)arraylist.get(found);
                Struct_Cost_Source send_cost = new Struct_Cost_Source();
                send_cost.setUnitcost(scd_src.getSend_cost().getUnitcost());
                send_cost.setSecond(scd_src.getSend_cost().getSecond() + scd_add.getSend_cost().getSecond());
                send_cost.setCost(scd_src.getSend_cost().getCost() + scd_add.getSend_cost().getCost());
                scd_src.setSend_cost(send_cost);
                Struct_Cost_Source recieve_cost = new Struct_Cost_Source();
                recieve_cost.setUnitcost(scd_src.getRecieve_cost().getUnitcost());
                recieve_cost.setSecond(scd_src.getRecieve_cost().getSecond() + scd_add.getRecieve_cost().getSecond());
                recieve_cost.setCost(scd_src.getRecieve_cost().getCost() + scd_add.getRecieve_cost().getCost());
                scd_src.setRecieve_cost(recieve_cost);
                scd_src.setTotal_cost(scd_src.getTotal_cost() + scd_add.getTotal_cost());
                scd_src.setEval_value(scd_src.getEval_value() + scd_add.getEval_value());
                scd_src.setAtvalue_cost(scd_src.getAtvalue_cost() + scd_add.getAtvalue_cost());
                arraylist.remove(i);
                arraylist.remove(found);
                arraylist.add(found, scd_src);
            }
            --i;
        }
        return arraylist;
    }

    private ArrayList yyyymm_Exclude(ArrayList arraylist) {
        if (arraylist == null || arraylist.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < arraylist.size()) {
            SimpleDateFormat dfm = new SimpleDateFormat("yyyyMM");
            Struct_Cost_Detail scd = (Struct_Cost_Detail)arraylist.get(i);
            if (!this.yyyymm.equals(dfm.format(scd.getGeneration_date()))) {
                arraylist.remove(i);
            }
            ++i;
        }
        return arraylist;
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

