/*
 * Decompiled with CFR 0.152.
 */
package tool;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import structure.File_and_Directory_Address;
import structure.Struct_Cost_Report;
import structure.Struct_System_Config;
import tool.Tool_LogOut;
import tool.Tool_System_Config_IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tool_Cost_Report_Calculate {
    ArrayList array_cost_report;
    int send_cost = 0;
    int recieve_cost = 0;
    int total_cost = 0;
    int eval_value = 0;
    int atvalue_cost = 0;
    File_and_Directory_Address addr = new File_and_Directory_Address();
    Struct_System_Config sysconfig = new Tool_System_Config_IO(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_config()).getStruct_System_Config();
    Tool_LogOut logout = new Tool_LogOut(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_log());

    public Tool_Cost_Report_Calculate(ArrayList<Struct_Cost_Report> array_cost_report) {
        if (this.sysconfig.isStandardmode()) {
            this.setStandard();
        }
        this.array_cost_report = array_cost_report;
    }

    public void Caluculate() {
        double send_cost = 0.0;
        double recieve_cost = 0.0;
        double total_cost = 0.0;
        double eval_value = 0.0;
        double atvalue_cost = 0.0;
        int i = 0;
        while (i < this.array_cost_report.size()) {
            Struct_Cost_Report scr = (Struct_Cost_Report)this.array_cost_report.get(i);
            send_cost += (double)scr.getSend_cost().getRealvalue();
            recieve_cost += (double)scr.getRecieve_cost().getRealvalue();
            total_cost += (double)scr.getTotal_cost().getRealvalue();
            eval_value += (double)scr.getEval_value().getRealvalue();
            atvalue_cost += (double)scr.getAteval_cost().getRealvalue();
            ++i;
        }
        this.send_cost = (int)send_cost;
        this.recieve_cost = (int)recieve_cost;
        this.total_cost = (int)total_cost;
        this.eval_value = (int)eval_value;
        this.atvalue_cost = (int)atvalue_cost;
    }

    public int getAtvalue_cost() {
        return this.atvalue_cost;
    }

    public int getEval_value() {
        return this.eval_value;
    }

    public int getRecieve_cost() {
        return this.recieve_cost;
    }

    public int getSend_cost() {
        return this.send_cost;
    }

    public int getTotal_cost() {
        return this.total_cost;
    }

    public void setStandard() {
        if (!this.sysconfig.isTestmode()) {
            try {
                System.setOut(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stdout(), true)));
                System.setErr(new PrintStream(new FileOutputStream(String.valueOf(this.addr.getDir_current()) + this.addr.getFile_stderr(), true)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getMessage());
                this.logout.out(this.sysconfig.getLogmode1(), this.getClass().getName(), e.getStackTrace());
            }
        }
    }
}

